/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.ExistingLfsCacheEntry;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.LfsCacheEntry;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.util.contentcache.CacheAccess;
import com.atlassian.util.contentcache.CacheEntry;
import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.CacheStreamAccess;
import com.atlassian.util.contentcache.ContentCacheManager;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.EvictionStrategy;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.AbstractContentCache;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;

public class LfsContentCache
extends AbstractContentCache {
    private final CacheExpiryStrategy cacheExpiryStrategy;
    private final ContentCacheManager contentCacheManager;
    private final EvictionStrategy evictionStrategy;
    private final LfsFileSystemHelper lfsFileSystemHelper;
    private final GitLfsSettingsService settingsService;

    public LfsContentCache(LfsFileSystemHelper lfsFileSystemHelper, CacheExpiryStrategy cacheExpiryStrategy, ContentCacheManager contentCacheManager, EvictionStrategy evictionStrategy, GitLfsSettingsService settingsService, StreamPumper streamPumper) {
        super("LFS", cacheExpiryStrategy, streamPumper);
        this.lfsFileSystemHelper = lfsFileSystemHelper;
        this.cacheExpiryStrategy = cacheExpiryStrategy;
        this.contentCacheManager = contentCacheManager;
        this.evictionStrategy = evictionStrategy;
        this.settingsService = settingsService;
    }

    @Nonnull
    public CacheAccess access(@Nonnull String key, @Nonnull OutputStream outputStream, @Nonnull ContentProvider contentProvider) throws IOException {
        this.maybePopulateFromDisk(key);
        return super.access(key, outputStream, contentProvider);
    }

    @Nonnull
    public CacheStreamAccess accessStream(@Nonnull String key, @Nonnull ContentProvider contentProvider) throws IOException {
        this.maybePopulateFromDisk(key);
        return super.accessStream(key, contentProvider);
    }

    protected CacheEntry newCacheEntry(@Nonnull String cacheKey, @Nonnull Date expiry) {
        Path objectFile = Paths.get(cacheKey, new String[0]);
        long usableSpace = this.lfsFileSystemHelper.getUsableSpace(objectFile);
        if (usableSpace < 1L) {
            log.warn("Insufficient available space to cache LFS file, bypassing mirror local storage and streaming directly from upstream. Available space is {} bytes. Free space threshold of {} bytes has been configured", (Object)usableSpace, (Object)this.lfsFileSystemHelper.getMinimumFreeSpace());
            return null;
        }
        if ((long)this.entries.size() > this.settingsService.getMirrorMaxInMemoryEntries()) {
            this.evictionStrategy.evict(this.settingsService.getMirrorEvictionEntries(), this.contentCacheManager);
        }
        return new LfsCacheEntry(cacheKey, this.cacheExpiryStrategy, objectFile);
    }

    private void maybePopulateFromDisk(String cacheKey) {
        Path objectFile;
        if (!this.entries.containsKey(cacheKey) && LfsFileSystemHelper.canOpen(objectFile = Paths.get(cacheKey, new String[0]))) {
            this.entries.putIfAbsent(cacheKey, new ExistingLfsCacheEntry(cacheKey, this.cacheExpiryStrategy, objectFile));
        }
    }
}

