/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import com.atlassian.bitbucket.dmz.throttle.DmzThrottleService;
import com.atlassian.bitbucket.dmz.throttle.Ticket;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.AbstractEmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.LfsFileSystemHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectByteRange;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectStreamingOutput;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ReadObjectRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.LfsContentCacheManager;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.LfsContentProvider;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.ReadOnlyMirrorException;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.UpstreamLfsClient;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.util.contentcache.BackgroundThreadStreamPumper;
import com.atlassian.util.contentcache.CacheAccess;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.EvictionStrategy;
import com.atlassian.util.contentcache.LruEntriesEvictionStrategy;
import com.atlassian.util.contentcache.StreamPumper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.DisposableBean;

public class MirrorEmbeddedStoreService
extends AbstractEmbeddedStoreService
implements DisposableBean {
    static final String LFS_CACHE_REGION = "LFS";
    private final ContentCache cache;
    private final StreamPumper pumper;
    private final DmzThrottleService throttleService;
    private final UpstreamLfsClient upstreamLfsClient;

    public MirrorEmbeddedStoreService(I18nService i18nService, LfsFileSystemHelper lfsFileSystemHelper, RepositoryService repositoryService, SecurityService securityService, GitLfsSettingsService settingsService, DmzThrottleService throttleService, UpstreamLfsClient upstreamLfsClient) {
        super(i18nService, lfsFileSystemHelper, repositoryService, securityService, settingsService);
        this.upstreamLfsClient = Objects.requireNonNull(upstreamLfsClient, "upstreamLfsClient");
        this.throttleService = Objects.requireNonNull(throttleService, "throttleService");
        this.pumper = new BackgroundThreadStreamPumper("lfs-stream-pumper");
        this.cache = new LfsContentCacheManager.Builder().lfsFileSystemHelper(Objects.requireNonNull(lfsFileSystemHelper, "lfsFileSystemHelper")).evictionStrategy((EvictionStrategy)new LruEntriesEvictionStrategy()).settingsService(Objects.requireNonNull(settingsService, "settingsService")).streamPumper(this.pumper).build().getCache(LFS_CACHE_REGION);
    }

    public void destroy() throws Exception {
        this.pumper.shutdown();
        this.upstreamLfsClient.destroy();
    }

    @Override
    @Nonnull
    public ObjectStreamingOutput readObject(@Nonnull ReadObjectRequest request) {
        this.requireLfsEnabled();
        this.validateOid(request.getOid());
        return new CachedObjectStreamingOutput(request);
    }

    @Override
    public void writeObject(@Nonnull Repository repository, @Nonnull String oid, @Nonnull InputStream is) {
        throw new ReadOnlyMirrorException(this.i18nService.createKeyedMessage("bitbucket.mirroring.scm.request.readonly.detail", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
    }

    private class CachedObjectStreamingOutput
    implements ObjectStreamingOutput {
        private final String oid;
        private final Repository repository;

        CachedObjectStreamingOutput(ReadObjectRequest request) {
            this.oid = request.getOid();
            this.repository = request.getRepository();
        }

        @Override
        @Nonnull
        public Optional<ObjectByteRange> range() {
            return Optional.empty();
        }

        public void write(OutputStream outputStream) throws IOException {
            Path objectFile = MirrorEmbeddedStoreService.this.lfsFileSystemHelper.getObjectPath(this.repository, this.oid);
            try (Ticket ignored = MirrorEmbeddedStoreService.this.throttleService.acquireTicket("git-lfs");
                 CacheAccess cacheAccess = MirrorEmbeddedStoreService.this.cache.access(objectFile.toString(), outputStream, (ContentProvider)new LfsContentProvider(this.repository, this.oid, MirrorEmbeddedStoreService.this.upstreamLfsClient));){
                cacheAccess.stream();
            }
        }
    }
}

