/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/admin")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LicensedOnly
public class GitLfsAdminResource {
    private final LfsService lfsService;

    @Inject
    public GitLfsAdminResource(LfsService lfsService) {
        this.lfsService = lfsService;
    }

    @DELETE
    @Path(value="/enabled")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response disableLfs() {
        this.lfsService.disable();
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response disableLfs(@BeanParam RepositoryResolver repositoryResolver) {
        this.lfsService.disable(repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="/enabled")
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response enableLfs() {
        this.lfsService.enable();
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response enableLfs(@BeanParam RepositoryResolver repositoryResolver) {
        this.lfsService.enable(repositoryResolver.getRepository());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="/enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getEnabled() {
        if (this.lfsService.isEnabled()) {
            return ResponseFactory.ok().build();
        }
        return ResponseFactory.notFound().build();
    }

    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getEnabled(@BeanParam RepositoryResolver repositoryResolver) {
        if (this.lfsService.isEnabled(repositoryResolver.getRepository())) {
            return ResponseFactory.ok().build();
        }
        return ResponseFactory.notFound().build();
    }
}

