/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockConflictException;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLock;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

@JsonSerialize
public class RestLfsError
extends RestMapEntity {
    public RestLfsError() {
    }

    public RestLfsError(Map<String, ?> values) {
        super(values);
    }

    public RestLfsError(@Nonnull Throwable t) {
        Objects.requireNonNull(t, "t");
        if (t.getClass().getName().equals("org.glassfish.hk2.api.MultiException")) {
            t = t.getCause();
        }
        String message = String.format("%s", t.getLocalizedMessage());
        if (t.getCause() != null && !t.getClass().equals(AuthorisationException.class)) {
            message = String.format("%s: %s", message, t.getCause().getLocalizedMessage());
        }
        this.put("message", message);
        if (t instanceof LfsLockConflictException) {
            LfsLock lock = ((LfsLockConflictException)((Object)t)).getLock();
            this.put("lock", (Object)new RestLfsLock(lock));
        }
    }
}

