/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockListRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLock;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Path(value="projects/{projectKey}/repos/{repositorySlug}/locks")
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GitLfsLockResource {
    private final LfsLockService lfsLockService;

    @Inject
    public GitLfsLockResource(@Nonnull LfsLockService lfsLockService) {
        this.lfsLockService = lfsLockService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getLocks(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="path") String path) {
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.endsWith((CharSequence)path, (CharSequence)"/")) {
            Page<LfsLock> locks = this.lfsLockService.listLocksByDirectory(repositoryResolver.getRepository(), StringUtils.defaultString((String)path), pageRequestResolver.getPageRequest());
            return this.toRestLfsLockResponse(locks);
        }
        LfsLockListRequest lockListRequest = new LfsLockListRequest.Builder(repositoryResolver.getRepository()).path(path).sendAnalytics(false).build();
        Page<LfsLock> locks = this.lfsLockService.listLocks(lockListRequest, pageRequestResolver.getPageRequest());
        return this.toRestLfsLockResponse(locks);
    }

    private Response toRestLfsLockResponse(Page<LfsLock> locks) {
        return ResponseFactory.ok().entity((Object)new RestPage(locks, RestLfsLock::new)).build();
    }
}

