/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.model;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchRequestException;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestBaseObject;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Map;

@JsonSerialize
public class RestRequestObject
extends RestBaseObject {
    public RestRequestObject(@Nonnull RequestObject requestObject) {
        super(requestObject);
    }

    protected RestRequestObject(@Nonnull Map<String, Object> values) {
        super(values);
    }

    @Nonnull
    public static RestRequestObject valueOf(@Nonnull Map<String, Object> values) {
        return new RestRequestObject(values);
    }

    @Nonnull
    public RequestObject fromRest(@Nonnull I18nService i18nService) {
        return new RequestObject(this.getOid(i18nService), this.getSize(i18nService));
    }

    @Nonnull
    private String getOid(@Nonnull I18nService i18nService) {
        String oid = this.getStringProperty("oid");
        if (oid == null) {
            throw new BadBatchRequestException(i18nService.getMessage("bitbucket.scm.git.lfs.request.missing.attribute", new Object[]{"oid"}));
        }
        return oid;
    }

    private long getSize(I18nService i18nService) {
        if (!this.containsKey("size")) {
            throw new BadBatchRequestException(i18nService.getMessage("bitbucket.scm.git.lfs.request.missing.attribute", new Object[]{"size"}));
        }
        try {
            return this.getLongProperty("size");
        }
        catch (NumberFormatException e) {
            throw new BadBatchRequestException(i18nService.getMessage("bitbucket.scm.git.lfs.request.invalid.size", new Object[0]));
        }
    }
}

