/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.model;

import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchResponseException;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionType;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestResponseAction;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@JsonSerialize
public class RestResponseActions
extends RestMapEntity {
    private static final String DOWNLOAD_KEY = "download";
    private static final String UPLOAD_KEY = "upload";
    private static final String VERIFY_KEY = "verify";

    public RestResponseActions(@Nonnull Collection<ResponseAction> actions) {
        actions.forEach(action -> this.put(RestResponseActions.keyFor(action.getType()), (Object)new RestResponseAction((ResponseAction)action)));
    }

    protected RestResponseActions(@Nonnull Map<String, Object> values) {
        super(values);
    }

    @Nonnull
    public static RestResponseActions valueOf(@Nonnull Map<String, Object> values) {
        return new RestResponseActions(values);
    }

    @Nonnull
    public List<ResponseAction> fromRest() {
        ArrayList<ResponseAction> actions = new ArrayList<ResponseAction>();
        this.addActionIfPresent(DOWNLOAD_KEY, ResponseActionType.DOWNLOAD, actions);
        this.addActionIfPresent(UPLOAD_KEY, ResponseActionType.UPLOAD, actions);
        this.addActionIfPresent(VERIFY_KEY, ResponseActionType.VERIFY, actions);
        return actions;
    }

    private static String keyFor(ResponseActionType type) {
        switch (type) {
            case DOWNLOAD: {
                return DOWNLOAD_KEY;
            }
            case UPLOAD: {
                return UPLOAD_KEY;
            }
            case VERIFY: {
                return VERIFY_KEY;
            }
        }
        throw new RuntimeException("Unhandled action type: " + type.name());
    }

    private void addActionIfPresent(String key, ResponseActionType type, List<ResponseAction> actions) {
        Map values = (Map)this.get(key);
        if (values != null) {
            RestResponseAction action = RestResponseAction.valueOf(values);
            String href = action.getHref().orElseThrow(() -> new BadBatchResponseException("Action is missing href attribute"));
            ResponseAction responseAction = new ResponseAction(type, href, action.getHeader());
            actions.add(responseAction);
        }
    }
}

