/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.model;

import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchResponseException;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

@JsonSerialize
public class RestResponseError
extends RestMapEntity {
    private static final String CODE_KEY = "code";
    private static final String MESSAGE_KEY = "message";

    public RestResponseError(int code, @Nonnull String message) {
        this.put(MESSAGE_KEY, Objects.requireNonNull(message, MESSAGE_KEY));
        this.put(CODE_KEY, code);
    }

    protected RestResponseError(@Nonnull Map<String, Object> values) {
        super(values);
    }

    @Nonnull
    public static RestResponseError valueOf(@Nonnull Map<String, Object> values) {
        return new RestResponseError(values);
    }

    public int getCode() {
        if (!this.containsKey(CODE_KEY)) {
            throw new BadBatchResponseException("Missing ''code'' attribute");
        }
        try {
            return this.getIntProperty(CODE_KEY);
        }
        catch (NumberFormatException e) {
            throw new BadBatchResponseException("Invalid ''code'' attribute");
        }
    }

    @Nonnull
    public String getMessage() {
        String message = this.getStringProperty(MESSAGE_KEY);
        if (message == null) {
            throw new BadBatchResponseException("Missing ''message'' attribute");
        }
        return message;
    }
}

