/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.ssh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.GitLfsJwtHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractRepositoryScmRequest;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.bitbucket.scm.ssh.ExitCodeCallback;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class GitLfsAuthenticateScmRequest
extends AbstractRepositoryScmRequest
implements SshScmRequest {
    private static final String RESPONSE_FORMAT = "{\"header\": {\"Authorization\": \"%1$s\"}, \"href\": \"%2$s\", \"expires_in\": %3$d}";
    private final ExitCodeCallback exitCodeCallback;
    private final I18nService i18nService;
    private final GitLfsJwtHelper jwtHelper;
    private final NavBuilder navBuilder;
    private final OutputStream out;
    private final GitLfsSettingsService settingsService;

    public GitLfsAuthenticateScmRequest(@Nonnull Repository repository, boolean write, @Nonnull ExitCodeCallback exitCodeCallback, @Nonnull I18nService i18nService, @Nonnull GitLfsJwtHelper jwtHelper, @Nonnull NavBuilder navBuilder, @Nonnull OutputStream out, @Nonnull GitLfsSettingsService settingsService) {
        super(repository, write);
        this.exitCodeCallback = Objects.requireNonNull(exitCodeCallback, "exitCodeCallback");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.jwtHelper = Objects.requireNonNull(jwtHelper, "jwtHelper");
        this.navBuilder = Objects.requireNonNull(navBuilder, "navBuilder");
        this.out = Objects.requireNonNull(out, "out");
        this.settingsService = Objects.requireNonNull(settingsService, "settingsService");
    }

    public void cancel() {
    }

    public void handleRequest() throws IOException {
        String lfsUrl = RepositoryUrlFragment.fromRepository((Repository)this.repository).toPath("/scm") + ".git/info/lfs";
        long tokenExpiry = this.settingsService.getBatchTokenExpiry();
        String token = this.jwtHelper.buildLfsApiToken(this.repository, tokenExpiry);
        String body = String.format(RESPONSE_FORMAT, token, this.navBuilder.buildAbsolute() + lfsUrl, tokenExpiry);
        this.out.write(body.getBytes(StandardCharsets.UTF_8));
        this.out.flush();
        this.exitCodeCallback.onExit(0);
    }

    public void sendError(@Nonnull String summary, @Nonnull String detail) throws IOException {
        String message = this.i18nService.getMessage("bitbucket.scm.git.lfs.ssh.remote.error", new Object[0]) + ": " + summary + "\n" + GitUtils.wordWrap((String)detail) + "\n";
        LfsHttpScmUtils.sendErrorMessage(this.out, message);
        this.out.flush();
    }
}

