/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.store;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchResponse;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestOperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionsObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseErrorObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.StoreAccessor;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AbstractStoreAccessor
implements StoreAccessor {
    private static final Pattern SHA256_PATTERN = Pattern.compile("[a-fA-F0-9]{64}");
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    protected AbstractStoreAccessor(ExecutorService executorService, I18nService i18nService, RepositoryService repositoryService, SecurityService securityService) {
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
    }

    @Override
    @Nonnull
    public abstract Optional<URI> createDownloadUrl(@Nonnull Repository var1, @Nonnull String var2, @Nullable String var3, @Nullable String var4);

    @Override
    public void delete(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        Page related = (Page)this.securityService.withPermission(Permission.REPO_READ, "Finding related repositories").call(() -> this.repositoryService.findRelated(repository, PageUtils.newRequest((int)0, (int)1)));
        if (related.getSize() == 0 && related.getIsLastPage()) {
            this.executorService.submit(() -> this.deleteObjectsForHierarchy(repository.getHierarchyId()));
        }
    }

    @Override
    @Nonnull
    public BatchResponse handleBatchRequest(@Nonnull Repository repository, @Nonnull BatchRequest request) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(request, "request");
        RequestOperationType type = request.getType();
        boolean sufficientCapacity = this.isCapacitySufficient(repository, request);
        List<ResponseObject> objects = request.getObjects().stream().map(requestObject -> this.handleRequest(repository, type, (RequestObject)requestObject, sufficientCapacity)).collect(Collectors.toList());
        return new BatchResponse(objects);
    }

    protected static boolean isValidSha256(@Nullable String hash) {
        return hash != null && SHA256_PATTERN.matcher(hash).matches();
    }

    @Nonnull
    protected abstract ResponseAction buildDownloadResponseAction(@Nonnull Repository var1, @Nonnull String var2);

    @Nonnull
    protected abstract ResponseAction buildUploadResponseAction(@Nonnull Repository var1, @Nonnull String var2);

    protected abstract void deleteObjectsForHierarchy(@Nonnull String var1);

    protected abstract boolean isCapacitySufficient(@Nonnull Repository var1, @Nonnull BatchRequest var2);

    protected abstract boolean objectExists(@Nonnull Repository var1, @Nonnull String var2);

    protected void validateOid(@Nonnull String oid) {
        Objects.requireNonNull(oid, "oid");
        if (!AbstractStoreAccessor.isValidSha256(oid)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.embeddedstore.object.id.invalid", new Object[0]));
        }
    }

    private ResponseObject handleRequest(Repository repository, RequestOperationType op, RequestObject request, boolean sufficientCapacity) {
        if (request.getSize() < 0L) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 422, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.object.size.invalid", new Object[0]));
        }
        if (!AbstractStoreAccessor.isValidSha256(request.getOid())) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 422, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.object.id.invalid", new Object[0]));
        }
        if (op.equals((Object)RequestOperationType.UPLOAD) && !sufficientCapacity) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 503, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.free.space.insufficient", new Object[0]));
        }
        if (op.equals((Object)RequestOperationType.DOWNLOAD) && !this.objectExists(repository, request.getOid())) {
            return new ResponseErrorObject(request.getOid(), request.getSize(), 404, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.object.notexist", new Object[0]));
        }
        if (op.equals((Object)RequestOperationType.UPLOAD) && this.objectExists(repository, request.getOid())) {
            return new ResponseActionsObject(request.getOid(), request.getSize(), Collections.emptyList());
        }
        if (op.equals((Object)RequestOperationType.DOWNLOAD)) {
            ResponseAction action = this.buildDownloadResponseAction(repository, request.getOid());
            return new ResponseActionsObject(request.getOid(), request.getSize(), Collections.singletonList(action));
        }
        if (op.equals((Object)RequestOperationType.UPLOAD)) {
            ResponseAction action = this.buildUploadResponseAction(repository, request.getOid());
            return new ResponseActionsObject(request.getOid(), request.getSize(), Collections.singletonList(action));
        }
        return new ResponseErrorObject(request.getOid(), request.getSize(), 400, this.i18nService.getMessage("bitbucket.scm.git.lfs.embeddedstore.operation.unhandled", new Object[0]));
    }
}

