/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.store;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.EmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.GitLfsJwtHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BaseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestOperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionType;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.AbstractStoreAccessor;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStoreAccessor
extends AbstractStoreAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultStoreAccessor.class);
    private final EmbeddedStoreService embeddedStoreService;
    private final GitLfsJwtHelper jwtHelper;
    private final NavBuilder navBuilder;
    private final GitLfsSettingsService settingsService;

    public DefaultStoreAccessor(EmbeddedStoreService embeddedStoreService, ExecutorService executorService, I18nService i18nService, GitLfsJwtHelper jwtHelper, NavBuilder navBuilder, RepositoryService repositoryService, SecurityService securityService, GitLfsSettingsService settingsService) {
        super(executorService, i18nService, repositoryService, securityService);
        this.embeddedStoreService = embeddedStoreService;
        this.jwtHelper = jwtHelper;
        this.navBuilder = navBuilder;
        this.settingsService = settingsService;
    }

    @Override
    @Nonnull
    public Optional<URI> createDownloadUrl(@Nonnull Repository repository, @Nonnull String oid, @Nullable String contentType, @Nullable String contentDisposition) {
        if (!this.embeddedStoreService.objectExists(repository, oid)) {
            return Optional.empty();
        }
        try {
            UriBuilder builder = UriBuilder.fromUri((URI)new URI(this.navBuilder.buildAbsolute())).path(this.getStoreUrl(repository, oid));
            if (contentType != null) {
                builder.queryParam("response-content-type", new Object[]{contentType});
            }
            if (contentDisposition != null) {
                builder.queryParam("response-content-disposition", new Object[]{contentDisposition});
            }
            return Optional.of(builder.build(new Object[0]));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid base URL", e);
        }
    }

    @Override
    public void delete(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.embeddedStoreService.delete(repository);
    }

    @Override
    @Nonnull
    protected ResponseAction buildDownloadResponseAction(@Nonnull Repository repository, @Nonnull String oid) {
        return this.buildResponseAction(repository, oid, "GET", ResponseActionType.DOWNLOAD);
    }

    @Override
    @Nonnull
    protected ResponseAction buildUploadResponseAction(@Nonnull Repository repository, @Nonnull String oid) {
        return this.buildResponseAction(repository, oid, "PUT", ResponseActionType.UPLOAD);
    }

    @Override
    protected void deleteObjectsForHierarchy(@Nonnull String hierarchyId) {
    }

    @Override
    protected boolean isCapacitySufficient(@Nonnull Repository repository, @Nonnull BatchRequest request) {
        if (request.getType() != RequestOperationType.UPLOAD) {
            return true;
        }
        long total = request.getObjects().stream().mapToLong(BaseObject::getSize).sum();
        boolean sufficientCapacity = this.embeddedStoreService.canStore(repository, total);
        if (!sufficientCapacity) {
            log.warn("Upload rejected due to insufficient available space to store {} bytes", (Object)total);
        }
        return sufficientCapacity;
    }

    @Override
    protected boolean objectExists(@Nonnull Repository repository, @Nonnull String oid) {
        return this.embeddedStoreService.objectExists(repository, oid);
    }

    private ResponseAction buildResponseAction(@Nonnull Repository repository, @Nonnull String oid, @Nonnull String method, @Nonnull ResponseActionType type) {
        Objects.requireNonNull(repository, "repository");
        this.validateOid(oid);
        String storeUrl = this.getStoreUrl(repository, oid);
        String token = this.jwtHelper.buildStorageToken((CanonicalHttpRequest)new CanonicalHttpUriRequest(method, storeUrl, null), repository, this.settingsService.getStorageTokenExpiry());
        return new ResponseAction(type, this.navBuilder.buildAbsolute() + storeUrl, (Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)token));
    }

    private String getStoreUrl(Repository repository, String oid) {
        return String.format("/rest/git-lfs/storage/%s/%s/%s", repository.getProject().getKey(), repository.getSlug(), oid);
    }
}

