/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.store;

import com.atlassian.bitbucket.dmz.filestore.FileStoreService;
import com.atlassian.bitbucket.filestore.DeleteRecursiveRequest;
import com.atlassian.bitbucket.filestore.FileExistsRequest;
import com.atlassian.bitbucket.filestore.FilePath;
import com.atlassian.bitbucket.filestore.FileStoreException;
import com.atlassian.bitbucket.filestore.GenerateGetUrlRequest;
import com.atlassian.bitbucket.filestore.GenerateGetUrlResponse;
import com.atlassian.bitbucket.filestore.GeneratePutUrlRequest;
import com.atlassian.bitbucket.filestore.GeneratePutUrlResponse;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BaseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestOperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseActionType;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.AbstractStoreAccessor;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreAccessor
extends AbstractStoreAccessor {
    public static final String FILESTORE_NAMESPACE = "git-lfs";
    private static final Logger log = LoggerFactory.getLogger((String)FileStoreAccessor.class.getName());
    private final FileStoreService fileStoreService;
    private final I18nService i18nService;
    private final GitLfsSettingsService settingsService;

    public FileStoreAccessor(ExecutorService executorService, FileStoreService fileStoreService, I18nService i18nService, RepositoryService repositoryService, SecurityService securityService, GitLfsSettingsService settingsService) {
        super(executorService, i18nService, repositoryService, securityService);
        this.fileStoreService = fileStoreService;
        this.i18nService = i18nService;
        this.settingsService = settingsService;
    }

    @Override
    @Nonnull
    public Optional<URI> createDownloadUrl(@Nonnull Repository repository, @Nonnull String oid, @Nullable String contentType, @Nullable String contentDisposition) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(oid, "oid");
        if (!this.objectExists(repository, oid)) {
            return Optional.empty();
        }
        GenerateGetUrlRequest.Builder requestBuilder = new GenerateGetUrlRequest.Builder().namespace(FILESTORE_NAMESPACE).path(new FilePath(this.toKey(repository, oid))).expiry(Duration.ofSeconds(this.settingsService.getStorageTokenExpiry()));
        if (contentType != null) {
            requestBuilder.responseContentType(contentType);
        }
        if (contentDisposition != null) {
            requestBuilder.responseContentDisposition(contentDisposition);
        }
        try {
            return Optional.of(this.fileStoreService.generateGetUrl(requestBuilder.build()).getUrl().toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    protected ResponseAction buildDownloadResponseAction(@Nonnull Repository repository, @Nonnull String oid) {
        Objects.requireNonNull(repository, "repository");
        this.validateOid(oid);
        GenerateGetUrlRequest request = new GenerateGetUrlRequest.Builder().namespace(FILESTORE_NAMESPACE).path(new FilePath(this.toKey(repository, oid))).expiry(Duration.ofSeconds(this.settingsService.getStorageTokenExpiry())).build();
        GenerateGetUrlResponse response = this.fileStoreService.generateGetUrl(request);
        return new ResponseAction(ResponseActionType.DOWNLOAD, response.getUrl().toString(), Collections.emptyMap());
    }

    @Override
    @Nonnull
    protected ResponseAction buildUploadResponseAction(@Nonnull Repository repository, @Nonnull String oid) {
        Objects.requireNonNull(repository, "repository");
        this.validateOid(oid);
        GeneratePutUrlRequest request = new GeneratePutUrlRequest.Builder().namespace(FILESTORE_NAMESPACE).path(new FilePath(this.toKey(repository, oid))).expiry(Duration.ofSeconds(this.settingsService.getStorageTokenExpiry())).checksumSHA256(this.hexToBase64(oid)).build();
        GeneratePutUrlResponse response = this.fileStoreService.generatePutUrl(request);
        HashMap<String, String> actionHeaders = new HashMap<String, String>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            actionHeaders.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        return new ResponseAction(ResponseActionType.UPLOAD, response.getUrl().toString(), actionHeaders);
    }

    @Override
    protected void deleteObjectsForHierarchy(@Nonnull String hierarchyId) {
        log.debug("Deleting LFS content for hierarchy {}", (Object)hierarchyId);
        DeleteRecursiveRequest request = new DeleteRecursiveRequest.Builder().namespace(FILESTORE_NAMESPACE).delete(new FilePath(hierarchyId + "/")).build();
        long count = this.fileStoreService.deleteRecursive(request);
        if (count > 0L) {
            log.debug("Deleted {} LFS objects for hierarchy {}", (Object)count, (Object)hierarchyId);
        }
    }

    @Override
    protected boolean isCapacitySufficient(@Nonnull Repository repository, @Nonnull BatchRequest request) {
        if (request.getType() != RequestOperationType.UPLOAD) {
            return true;
        }
        long total = request.getObjects().stream().mapToLong(BaseObject::getSize).sum();
        return this.fileStoreService.getFreeSpace().map(freeSpace -> freeSpace >= total).orElse(true);
    }

    @Override
    protected boolean objectExists(@Nonnull Repository repository, @Nonnull String oid) {
        return this.fileStoreService.fileExists(new FileExistsRequest.Builder().namespace(FILESTORE_NAMESPACE).path(new FilePath(this.toKey(repository, oid))).build());
    }

    private String hexToBase64(String hex) {
        try {
            return Base64.getEncoder().encodeToString(Hex.decodeHex((String)hex));
        }
        catch (DecoderException e) {
            throw new FileStoreException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.embeddedstore.object.id.invalid", new Object[0]));
        }
    }

    private String toKey(Repository repository, String oid) {
        return repository.getHierarchyId() + "/" + oid.substring(0, 2) + "/" + oid.substring(2);
    }
}

