/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public final class CommonValidations {
    private static final Predicate<String> NOT_NULL_OR_EMPTY = value -> !Strings.isNullOrEmpty((String)value);

    public static void validateGrantablePermission(Permission permission) {
        Objects.requireNonNull(permission, "Permission is null");
        Preconditions.checkArgument((boolean)permission.isGrantable(), (Object)"Permission is not a grantable permission");
    }

    public static void validateGlobalPermission(Permission permission) {
        Objects.requireNonNull(permission, "Permission is null");
        Preconditions.checkArgument((boolean)permission.isGlobal(), (Object)"Permission is not a global permission");
    }

    public static void validateProjectPermission(Permission permission) {
        Objects.requireNonNull(permission, "Permission is null");
        Preconditions.checkArgument((boolean)permission.isResource(Project.class), (Object)"Permission is not a project permission");
    }

    public static void validateRepositoryPermission(Permission permission) {
        Objects.requireNonNull(permission, "Permission is null");
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class), (Object)"Permission is not a repository permission");
    }

    public static void validateUserPermission(Permission permission) {
        Objects.requireNonNull(permission, "Permission is null");
        Preconditions.checkArgument((boolean)permission.isResource(ApplicationUser.class), (Object)"Permission is not a user permission");
    }

    public static void validateResourcePermission(Permission permission) {
        Objects.requireNonNull(permission, "Permission is null");
        Preconditions.checkArgument((boolean)permission.isResource(), (Object)"Permission is not a resource-based permission");
    }

    public static void validateUser(String username) {
        Preconditions.checkArgument((boolean)NOT_NULL_OR_EMPTY.test(username), (Object)"Username is empty");
    }

    public static void validateGroup(String group) {
        Preconditions.checkArgument((boolean)NOT_NULL_OR_EMPTY.test(group), (Object)"Group is empty");
    }

    public static void validateGroups(Collection<String> groups) {
        Objects.requireNonNull(groups, "groups");
        Preconditions.checkArgument((boolean)Iterables.all(groups, NOT_NULL_OR_EMPTY::test), (Object)"Groups has empty groups");
    }
}

