/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.security.csp.api.CspDirective;
import com.atlassian.security.csp.api.internal.ContentSecurityPolicy;
import com.atlassian.security.csp.api.internal.NonceService;
import com.atlassian.security.csp.spi.CspProvider;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.List;

public class ContentSecurityPolicyProvider
implements CspProvider {
    private final ApplicationPropertiesService applicationProperties;
    private final HttpContext httpContext;
    private final NonceService nonceService;

    public ContentSecurityPolicyProvider(ApplicationPropertiesService applicationProperties, HttpContext httpContext, NonceService nonceService) {
        this.applicationProperties = applicationProperties;
        this.httpContext = httpContext;
        this.nonceService = nonceService;
    }

    public List<String> getExclusionPatterns() {
        return List.of();
    }

    public ContentSecurityPolicy getPolicy() {
        String nonce = this.nonceService.getNonce();
        HttpServletRequest request = this.httpContext.getRequest();
        URI configuredBaseUrl = this.applicationProperties.getBaseUrl();
        String contextPath = request == null ? "" : request.getContextPath();
        ContentSecurityPolicy.Builder builder = new ContentSecurityPolicy.Builder();
        if (configuredBaseUrl != null) {
            builder.addToDirective(CspDirective.SCRIPT_SRC, String.valueOf(configuredBaseUrl) + "/s/");
        }
        return builder.addToDirective(CspDirective.DEFAULT_SRC, "'self'").addToDirective(CspDirective.BASE_URI, "'self'").addToDirective(CspDirective.SCRIPT_SRC, contextPath + "/s/").addNonce(CspDirective.SCRIPT_SRC, nonce).addToDirective(CspDirective.IMG_SRC, "data:").addToDirective(CspDirective.IMG_SRC, "*").addToDirective(CspDirective.STYLE_SRC, "'self'").addToDirective(CspDirective.STYLE_SRC, "'unsafe-inline'").addToDirective(CspDirective.FRAME_SRC, "'self'").addToDirective(CspDirective.FRAME_SRC, "https://www.youtube-nocookie.com/embed/").addToDirective(CspDirective.FRAME_SRC, "https://www.loom.com/embed/").addToDirective(CspDirective.FRAME_SRC, "https://player.vimeo.com/video/").addToDirective(CspDirective.CONNECT_SRC, "'self'").build();
    }
}

