/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.accessibility;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.accessibility.ColorFilter;
import com.atlassian.bitbucket.dmz.accessibility.UserColorFilterSettingsService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=UserColorFilterSettingsService.class)
@Service(value="userColorFilterSettingsService")
public class DefaultUserColorFilterSettingsService
implements UserColorFilterSettingsService {
    static final String PROP_COLOR_FILTER_VALUE = "bitbucket.color.filter";
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final TransactionTemplate transactionTemplate;
    private final UserSettingsService userSettingsService;

    @Autowired
    public DefaultUserColorFilterSettingsService(AuthenticationContext authenticationContext, I18nService i18nService, TransactionTemplate transactionTemplate, UserSettingsService userSettingsService) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.transactionTemplate = transactionTemplate;
        this.userSettingsService = userSettingsService;
    }

    @Nonnull
    public Optional<ColorFilter> getColorFilter() {
        return this.getCurrentUser().flatMap(this::getColorFilter);
    }

    public void updateColorFilter(@Nonnull ColorFilter colorFilter) {
        Objects.requireNonNull(colorFilter, "colorFilter");
        UserKey user = this.getCurrentUser().orElseThrow(() -> new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.accessibility.color-filter.update.anonymous", new Object[0])));
        this.updateColorFilter(user, colorFilter);
    }

    private Optional<ColorFilter> getColorFilter(UserKey user) {
        return this.userSettingsService.getUserSettings(user).getString(PROP_COLOR_FILTER_VALUE).toOptional().map(ColorFilter::fromValue);
    }

    private Optional<UserKey> getCurrentUser() {
        return Optional.ofNullable(this.authenticationContext.getCurrentUser()).map(user -> UserKey.fromLong((long)user.getId()));
    }

    private void updateColorFilter(UserKey user, ColorFilter colorFilter) {
        this.transactionTemplate.execute(() -> {
            Optional<ColorFilter> current = this.getColorFilter(user);
            if (current.isEmpty() || !current.get().equals((Object)colorFilter)) {
                this.userSettingsService.updateUserSettings(user, builder -> builder.put(PROP_COLOR_FILTER_VALUE, colorFilter.getValue()).build());
            }
            return null;
        });
    }
}

