/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.attach;

import com.atlassian.bitbucket.DataStoreException;
import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.attachment.Attachment;
import com.atlassian.bitbucket.attachment.AttachmentDeletionCanceledException;
import com.atlassian.bitbucket.attachment.AttachmentMetadata;
import com.atlassian.bitbucket.attachment.AttachmentSaveCanceledException;
import com.atlassian.bitbucket.attachment.AttachmentService;
import com.atlassian.bitbucket.attachment.AttachmentStoreException;
import com.atlassian.bitbucket.attachment.AttachmentSupplier;
import com.atlassian.bitbucket.attachment.InvalidAttachmentMetadataException;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.event.attachment.AttachmentDeletedEvent;
import com.atlassian.bitbucket.event.attachment.AttachmentDeletionRequestedEvent;
import com.atlassian.bitbucket.event.attachment.AttachmentSaveRequestedEvent;
import com.atlassian.bitbucket.event.attachment.AttachmentSavedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.IoUtils;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.attach.AttachmentsDisabledException;
import com.atlassian.stash.internal.attach.ImportAttachmentDetailsRequest;
import com.atlassian.stash.internal.attach.InternalAttachmentService;
import com.atlassian.stash.internal.attachment.AttachmentDao;
import com.atlassian.stash.internal.attachment.AttachmentMetadataDao;
import com.atlassian.stash.internal.attachment.InternalAttachment;
import com.atlassian.stash.internal.attachment.InternalAttachmentMetadata;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.server.InternalStorageService;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

@AvailableToPlugins(value=AttachmentService.class)
@Service(value="attachmentService")
@Transactional(readOnly=true)
public class DefaultAttachmentService
implements InternalAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAttachmentService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final AttachmentDao attachmentDao;
    private final AttachmentMetadataDao attachmentMetadataDao;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final LockService lockService;
    private final TransactionSynchronizer synchronizer;
    private final InternalStorageService storageService;
    @Value(value="${page.max.attachments}")
    private int maxAttachments;

    @Autowired
    public DefaultAttachmentService(InternalApplicationPropertiesService applicationPropertiesService, AttachmentDao attachmentDao, AttachmentMetadataDao attachmentMetadataDao, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, LockService lockService, TransactionSynchronizer synchronizer, InternalStorageService storageService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.attachmentDao = attachmentDao;
        this.attachmentMetadataDao = attachmentMetadataDao;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.synchronizer = synchronizer;
        this.storageService = storageService;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean delete(@Nonnull Repository repository, @Nonnull String id) {
        Path attachment = this.findLegacyAttachment(repository, id);
        try {
            Files.delete(attachment);
            log.debug("{}: Deleted attachment {}", (Object)repository, (Object)id);
            try {
                Files.delete(attachment.getParent());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        catch (IOException e) {
            boolean notFound = e instanceof FileNotFoundException || e instanceof NoSuchFileException;
            log.debug("{}: Attachment {} could not be deleted (Exists: {})", new Object[]{repository, id, !notFound});
            return false;
        }
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional
    public boolean delete(@Nonnull Repository repository, long id) {
        InternalAttachment attachment = (InternalAttachment)this.attachmentDao.getById((Object)id);
        if (!this.checkAttachmentBelongsToRepository(repository, attachment)) {
            log.debug("{}: Attachment {} does not exist", (Object)repository, (Object)id);
            return false;
        }
        this.fireDeleteRequested(repository, (Attachment)attachment);
        this.attachmentDao.delete((Object)attachment);
        try {
            Files.delete(this.getCompleteFilePath(repository, id));
            this.eventPublisher.publish((Object)new AttachmentDeletedEvent((Object)this, repository, (Attachment)attachment));
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.warn("{}: Attachment {} existed in the database, but not on disk", (Object)repository, (Object)id);
            return false;
        }
        catch (IOException e) {
            throw new AttachmentStoreException(this.i18nService.createKeyedMessage("bitbucket.attachment.nosuchattachment", new Object[]{id}), (Throwable)e);
        }
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional
    public boolean deleteMetadata(@Nonnull Repository repository, long attachmentId) {
        InternalAttachmentMetadata attachmentMetadata = (InternalAttachmentMetadata)this.attachmentMetadataDao.getById((Object)attachmentId);
        if (attachmentMetadata == null || !this.checkAttachmentBelongsToRepository(repository, attachmentMetadata.getAttachment())) {
            log.debug("{}: Could not delete the attachment metadata {}", (Object)repository, (Object)attachmentId);
            return false;
        }
        this.attachmentMetadataDao.deleteById((Object)attachmentId);
        log.debug("{}: Deleted attachment metadata {}", (Object)repository, (Object)attachmentId);
        return true;
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public void export(@Nonnull Repository repository, @Nonnull BiConsumer<Attachment, AttachmentMetadata> exporter) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(exporter, "exporter");
        this.attachmentDao.exportAll(repository.getId(), exporter, this.maxAttachments);
    }

    @PostAuthorize(value="hasRepositoryPermission(returnObject?.repository, 'REPO_READ')")
    public Attachment getById(long attachmentId) {
        InternalAttachment attachment = (InternalAttachment)this.attachmentDao.getById((Object)attachmentId);
        return attachment;
    }

    @Unsecured(value="Anyone is allowed to check the maximum content upload size")
    public long getMaxUploadSize() {
        return Long.parseLong(this.applicationPropertiesService.getProperty("attachment.upload.max.size"));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public AttachmentMetadata getMetadata(@Nonnull Repository repository, long attachmentId) {
        InternalAttachmentMetadata attachmentMetadata = (InternalAttachmentMetadata)this.attachmentMetadataDao.getById((Object)attachmentId);
        if (attachmentMetadata == null || !this.checkAttachmentBelongsToRepository(repository, attachmentMetadata.getAttachment())) {
            throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.attachment.metadata.nosuchattachmentmetadata", new Object[]{Long.toString(attachmentId)}), Long.toString(attachmentId));
        }
        return attachmentMetadata;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public long getSize(@Nonnull Repository repository) {
        Path repositoryDir = this.storageService.getAttachmentsDir(repository);
        return Files.isDirectory(repositoryDir, new LinkOption[0]) ? MoreFiles.totalSize((Path)repositoryDir) : 0L;
    }

    @Nonnull
    @Unsecured(value="Internal service method; no permission check necessary")
    @Transactional
    public Attachment importAttachmentDetails(@Nonnull ImportAttachmentDetailsRequest attachmentDetailsRequest) {
        Objects.requireNonNull(attachmentDetailsRequest, "attachmentDetailsRequest");
        InternalAttachment attachment = (InternalAttachment)this.attachmentDao.create((Object)new InternalAttachment.Builder(attachmentDetailsRequest.getFilename(), (InternalRepository)attachmentDetailsRequest.getRepository()).build());
        if (attachmentDetailsRequest.getMetadata() != null) {
            this.attachmentMetadataDao.create((Object)new InternalAttachmentMetadata.Builder(attachment, attachmentDetailsRequest.getMetadata()).build());
        }
        return attachment;
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public void importAttachmentFile(@Nonnull Repository repository, long attachmentId, @Nonnull IoConsumer<Path> writeCallback) throws IOException {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(writeCallback, "writeCallBack");
        InternalAttachment attachment = (InternalAttachment)this.attachmentDao.getById((Object)attachmentId);
        if (attachment == null) {
            log.debug("{}: Attachment {} does not exist", (Object)repository, (Object)attachmentId);
            throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.attachment.nosuchattachment", new Object[]{Long.toString(attachmentId)}), Long.toString(attachmentId));
        }
        writeCallback.accept((Object)this.getCompleteFilePath(repository, attachmentId));
    }

    @Unsecured(value="Internal service method; no permission check necessary")
    public void importAttachmentFile(@Nonnull Repository repository, @Nonnull String id, @Nonnull IoConsumer<Path> writeCallback) throws IOException {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(writeCallback, "writeCallBack");
        writeCallback.accept((Object)this.findLegacyAttachment(repository, id));
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        Repository repository = event.getRepository();
        Path repositoryDir = this.storageService.getAttachmentsDir(repository);
        if (Files.isDirectory(repositoryDir, new LinkOption[0])) {
            if (MoreFiles.deleteQuietly((Path)repositoryDir)) {
                log.info("{}: Deleted all attachments", (Object)repository);
            } else {
                log.warn("{}: Some attachments could not be deleted", (Object)repository);
            }
        } else {
            log.debug("{}: No attachments to delete", (Object)repository);
        }
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public AttachmentSupplier read(@Nonnull Repository repository, long id) {
        Path path;
        Objects.requireNonNull(repository, "repository");
        InternalAttachment attachment = (InternalAttachment)this.attachmentDao.getById((Object)id);
        if (this.checkAttachmentBelongsToRepository(repository, attachment) && Files.isRegularFile(path = this.getCompleteFilePath(repository, attachment.getId()), new LinkOption[0])) {
            return new FileAttachmentSupplier(path, attachment.getFilename());
        }
        throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.attachment.nosuchattachment", new Object[]{id}), Long.toString(id));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public AttachmentSupplier read(@Nonnull Repository repository, @Nonnull String id) {
        Path attachment = this.findLegacyAttachment(repository, id);
        if (Files.isRegularFile(attachment, new LinkOption[0])) {
            return new FileAttachmentSupplier(attachment);
        }
        throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.attachment.nosuchattachment", new Object[]{id}), id);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Attachment save(final @Nonnull Repository repository, @Nonnull AttachmentSupplier supplier) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(supplier, "supplier");
        this.checkFeatureEnabled();
        final InternalAttachment attachmentRecord = (InternalAttachment)this.attachmentDao.create((Object)new InternalAttachment.Builder(supplier.getName(), (InternalRepository)repository).build());
        final long attachmentId = attachmentRecord.getId();
        this.fireAddRequested(repository, (Attachment)attachmentRecord);
        Path shardedDirectory = this.createShardedDirectory(repository, attachmentId);
        final Path storedFileName = shardedDirectory.resolve(Long.toString(attachmentId));
        try (InputStream inputStream = supplier.open();){
            Files.createFile(storedFileName, new FileAttribute[0]);
            MoreFiles.setSafeFilePermissions((Path)storedFileName);
            IoUtils.copy((InputStream)inputStream, (File)storedFileName.toFile());
            this.eventPublisher.publish((Object)new AttachmentSavedEvent((Object)this, repository, (Attachment)attachmentRecord));
        }
        catch (IOException e) {
            throw new DataStoreException(this.i18nService.createKeyedMessage("bitbucket.attachment.writefailed", new Object[]{storedFileName}), (Throwable)e);
        }
        this.synchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                if (status != 0) {
                    try {
                        DefaultAttachmentService.this.fireDeleteRequested(repository, (Attachment)attachmentRecord);
                        Files.delete(storedFileName);
                        DefaultAttachmentService.this.eventPublisher.publish((Object)new AttachmentDeletedEvent((Object)this, repository, (Attachment)attachmentRecord));
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        log.debug("{}: Attachment {} was not found and could not be deleted.", (Object)repository, (Object)attachmentId);
                    }
                    catch (IOException e) {
                        log.error("File {} could not be cleaned up after transaction failed to commit", (Object)storedFileName);
                    }
                }
            }
        });
        return attachmentRecord;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public List<Either<ServiceException, Attachment>> saveAll(@Nonnull Repository repository, @Nonnull List<AttachmentSupplier> suppliers) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(suppliers, "suppliers");
        this.checkFeatureEnabled();
        ArrayList<Either<ServiceException, Attachment>> result = new ArrayList<Either<ServiceException, Attachment>>();
        suppliers.forEach(attachmentSupplier -> {
            try {
                result.add(Either.right((Object)this.save(repository, (AttachmentSupplier)attachmentSupplier)));
            }
            catch (ServiceException e) {
                result.add(Either.left((Object)((Object)e)));
            }
        });
        return result;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public AttachmentMetadata saveMetadata(@Nonnull Repository repository, long attachmentId, @Nonnull Map<String, Object> metadata) {
        Objects.requireNonNull(metadata, "metadata");
        this.checkFeatureEnabled();
        String metadataJson = this.validateMetadata(metadata);
        InternalAttachment attachment = (InternalAttachment)this.attachmentDao.getById((Object)attachmentId);
        if (!this.checkAttachmentBelongsToRepository(repository, attachment)) {
            throw new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.attachment.nosuchattachment", new Object[]{Long.toString(attachmentId)}), Long.toString(attachmentId));
        }
        return (AttachmentMetadata)this.attachmentMetadataDao.update((Object)new InternalAttachmentMetadata.Builder(attachment, metadataJson).build());
    }

    private static String getShardFolder(long id) {
        return Long.toString(id % 256L);
    }

    private static Path getShardPath(long attachmentId, Path attachmentsDir) {
        String shardedFolder = DefaultAttachmentService.getShardFolder(attachmentId);
        return attachmentsDir.resolve(shardedFolder);
    }

    private boolean checkAttachmentBelongsToRepository(Repository repository, InternalAttachment attachment) {
        return attachment != null && attachment.getRepository().getId() == repository.getId();
    }

    private void checkFeatureEnabled() {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.ATTACHMENTS)) {
            throw new AttachmentsDisabledException(this.i18nService.createKeyedMessage("bitbucket.attachment.disabled", new Object[0]));
        }
    }

    private Path createShardedDirectory(Repository repository, long id) {
        Path path;
        block8: {
            Path repositoryDir = this.storageService.getAttachmentsDir(repository);
            Path shardedDir = DefaultAttachmentService.getShardPath(id, repositoryDir);
            String lockName = "bitbucket:attachments:createShard:" + String.valueOf(shardedDir.getFileName());
            LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(lockName));
            try {
                MoreFiles.mkdir((Path)shardedDir);
                MoreFiles.setSafeDirectoryPermissions((Path)shardedDir);
                path = shardedDir;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalStateException e) {
                    throw new DataStoreException(this.i18nService.createKeyedMessage("bitbucket.attachment.tokeninuse", new Object[0]), (Throwable)e);
                }
            }
            ignored.close();
        }
        return path;
    }

    private Path findLegacyAttachment(Repository repository, String id) {
        Objects.requireNonNull(repository, "repository");
        Preconditions.checkArgument((!Objects.requireNonNull(id, "id").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank ID is required");
        String[] paths = id.split("[\\\\/]");
        if (paths.length != 2 || "..".equals(paths[0])) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.attachment.invalidid", new Object[]{id}));
        }
        return this.storageService.getAttachmentsDir(repository).resolve(paths[0]).resolve(paths[1]);
    }

    private void fireAddRequested(Repository repository, Attachment attachment) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new AttachmentSaveRequestedEvent((Object)this, repository, attachment, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.attachment.addcanceled", new Object[0]);
            throw new AttachmentSaveCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireDeleteRequested(Repository repository, Attachment attachment) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new AttachmentDeletionRequestedEvent((Object)this, repository, attachment, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.attachment.deletioncanceled", new Object[0]);
            throw new AttachmentDeletionCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private Path getCompleteFilePath(Repository repository, long attachmentId) {
        Path sharedPath = DefaultAttachmentService.getShardPath(attachmentId, this.storageService.getAttachmentsDir(repository));
        return sharedPath.resolve(Long.toString(attachmentId));
    }

    private String validateMetadata(Map<String, Object> metadata) {
        if (metadata.isEmpty()) {
            throw new InvalidAttachmentMetadataException(this.i18nService.createKeyedMessage("bitbucket.attachment.metadata.empty.error", new Object[0]));
        }
        try {
            String metadataJson = MAPPER.writeValueAsString(metadata);
            if (metadataJson.length() > 32768) {
                throw new InvalidAttachmentMetadataException(this.i18nService.createKeyedMessage("bitbucket.attachment.metadata.length.error", new Object[0]));
            }
            return metadataJson;
        }
        catch (IOException e) {
            throw new InvalidAttachmentMetadataException(this.i18nService.createKeyedMessage("bitbucket.attachment.metadata.serialization.error", new Object[0]), (Throwable)e);
        }
    }

    private static class FileAttachmentSupplier
    implements AttachmentSupplier {
        private final Path file;
        private final String filename;

        private FileAttachmentSupplier(Path file) {
            this(file, file.getFileName().toString());
        }

        private FileAttachmentSupplier(Path file, String filename) {
            this.file = file;
            this.filename = filename;
        }

        @Nonnull
        public String getName() {
            return this.filename;
        }

        public long getSize() {
            return MoreFiles.size((Path)this.file);
        }

        @Nonnull
        public InputStream open() throws IOException {
            return Files.newInputStream(this.file, new OpenOption[0]);
        }
    }
}

