/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBanner;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.banner.event.AnnouncementBannerDeletedEvent;
import com.atlassian.stash.internal.banner.event.AnnouncementBannerSetEvent;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncementBannerEventListener {
    @VisibleForTesting
    static final String ACTION_CREATED = "bitbucket.service.announcement.audit.action.announcementbannercreated";
    @VisibleForTesting
    static final String ACTION_DELETED = "bitbucket.service.announcement.audit.action.announcementbannerdeleted";
    @VisibleForTesting
    static final String ACTION_UPDATED = "bitbucket.service.announcement.audit.action.announcementbannerupdated";
    @VisibleForTesting
    static final String ATTR_AUDIENCE = "bitbucket.service.announcement.audit.attribute.announcementbannerupdated.audience";
    @VisibleForTesting
    static final String ATTR_ENABLED = "bitbucket.service.announcement.audit.attribute.announcementbannerupdated.enabled";
    @VisibleForTesting
    static final String ATTR_MESSAGE = "bitbucket.service.announcement.audit.attribute.announcementbannerupdated.message";
    private final AuditService auditService;

    @Autowired
    public AnnouncementBannerEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onAnnouncementBannerDeletedEvent(AnnouncementBannerDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.globaladministration", (String)ACTION_DELETED).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MESSAGE, (String)event.getBanner().getMessage()).build()).build());
    }

    @EventListener
    public void onAnnouncementBannerSetEvent(AnnouncementBannerSetEvent event) {
        AnnouncementBanner current = event.getAnnouncementBanner();
        AuditEvent auditEvent = event.getPreviousBanner().map(previous -> AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.globaladministration", (String)ACTION_UPDATED).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_MESSAGE).from(previous.getMessage()).to(current.getMessage()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_AUDIENCE).from(previous.getAudience().toString()).to(current.getAudience().toString()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_ENABLED).from(Boolean.toString(previous.isEnabled())).to(Boolean.toString(current.isEnabled())).build())).orElseGet(() -> AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.globaladministration", (String)ACTION_CREATED).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MESSAGE, (String)current.getMessage()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_AUDIENCE, (String)current.getAudience().toString()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ENABLED, (String)Boolean.toString(current.isEnabled())).build())).build();
        this.auditService.audit(auditEvent);
    }
}

