/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.dmz.annotation.InternalAuditable;
import com.atlassian.bitbucket.event.annotation.Auditable;
import com.atlassian.event.api.EventListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component(value="auditableAnnotatedEventListener")
public class AuditableAnnotatedEventListener {
    static final AuditType EXCEPTION_AUDIT_TYPE = AuditType.fromI18nKeys((CoverageArea)CoverageArea.AUDIT_LOG, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.system", (String)"bitbucket.audit.action.auditableannotationexception").build();
    static final CoverageArea EXTERNAL_EVENT_AREA = CoverageArea.ECOSYSTEM;
    private static final Logger log = LoggerFactory.getLogger(AuditableAnnotatedEventListener.class);
    private final AuditService auditService;

    @Autowired
    public AuditableAnnotatedEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onEvent(Object event) throws Exception {
        Auditable externalAuditable = (Auditable)AnnotationUtils.findAnnotation(event.getClass(), Auditable.class);
        InternalAuditable internalAuditable = (InternalAuditable)AnnotationUtils.findAnnotation(event.getClass(), InternalAuditable.class);
        if (externalAuditable == null && internalAuditable == null) {
            return;
        }
        AuditType type = internalAuditable == null ? AuditType.fromI18nKeys((CoverageArea)EXTERNAL_EVENT_AREA, (CoverageLevel)externalAuditable.coverageLevel(), (String)externalAuditable.category(), (String)((String)StringUtils.firstNonBlank((CharSequence[])new String[]{externalAuditable.action(), event.getClass().getSimpleName()}))).build() : AuditType.fromI18nKeys((CoverageArea)internalAuditable.coverageArea(), (CoverageLevel)internalAuditable.coverageLevel(), (String)internalAuditable.categoryI18nKey(), (String)internalAuditable.actionI18nKey()).build();
        try {
            AuditEventConverter converter = internalAuditable == null ? (AuditEventConverter)externalAuditable.converter().newInstance() : (AuditEventConverter)internalAuditable.converter().newInstance();
            this.auditService.audit(converter.convert(event, AuditEvent.builder((AuditType)type)));
        }
        catch (InstantiationException ex) {
            log.error("Failed to convert and publish @Auditable annotated event {} of type {} due to {}. Note that AuditEventConverter requires a default no-args constructor.", new Object[]{event, event.getClass(), ex.getMessage()});
            this.auditAndRethrow(ex);
        }
        catch (Exception ex) {
            log.error("Failed to convert and publish @Auditable annotated event {} of type {} due to {}.", new Object[]{event, event.getClass(), ex.getMessage()});
            this.auditAndRethrow(ex);
        }
    }

    private <T extends Exception> void auditAndRethrow(T ex) throws T {
        this.auditService.audit(AuditEvent.builder((AuditType)EXCEPTION_AUDIT_TYPE).build());
        throw ex;
    }
}

