/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.auth.AbstractAuthenticationEvent;
import com.atlassian.bitbucket.event.auth.AuthenticationFailureEvent;
import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="authenticationEventListener")
public class AuthenticationEventListener {
    @VisibleForTesting
    static final String ACTION_AUTHENTICATION_FAILED = "bitbucket.service.user.audit.action.authenticationfailure";
    @VisibleForTesting
    static final String ACTION_AUTHENTICATION_SUCCESS = "bitbucket.service.user.audit.action.authenticationsuccess";
    @VisibleForTesting
    static final String ATTR_AUTH_METHOD = "bitbucket.service.user.audit.attribute.authentication.authmethod";
    @VisibleForTesting
    static final String ATTR_ERROR = "bitbucket.service.user.audit.attribute.authenticationfailure.error";
    @VisibleForTesting
    static final String ATTR_TOKEN_DETAILS = "bitbucket.service.user.audit.attribute.authenticationsuccess.tokendetails";
    @VisibleForTesting
    static final String ATTR_USERNAME = "bitbucket.service.user.audit.attribute.authenticationfailure.username";
    private final AuditService auditService;

    @Autowired
    public AuthenticationEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onAuthenticationFailure(AuthenticationFailureEvent event) {
        AuditEvent.Builder builder = this.getAuthenticationEventBuilder((AbstractAuthenticationEvent)event, ACTION_AUTHENTICATION_FAILED, CoverageLevel.ADVANCED);
        if (event.getException() != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ERROR, (String)event.getException().getLocalizedMessage()).build());
        }
        if (event.getUsername() != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_USERNAME, (String)event.getUsername()).build());
        }
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onAuthenticationSuccess(AuthenticationSuccessEvent event) {
        AuditEvent.Builder builder = this.getAuthenticationEventBuilder((AbstractAuthenticationEvent)event, ACTION_AUTHENTICATION_SUCCESS, CoverageLevel.FULL);
        if (StringUtils.isNotBlank((CharSequence)event.getTokenDetails())) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TOKEN_DETAILS, (String)event.getTokenDetails()).build());
        }
        this.auditService.audit(builder.build());
    }

    private AuditEvent.Builder getAuthenticationEventBuilder(AbstractAuthenticationEvent event, String action, CoverageLevel level) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)level, (String)"bitbucket.service.audit.category.authentication", (String)action).build();
        return AuditEvent.builder((AuditType)auditType).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_AUTH_METHOD, (String)event.getAuthenticationMethod()).build());
    }
}

