/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsCreatedEvent;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsDeletedEvent;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsEvent;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsUpdatedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoDeclineEventListener {
    @VisibleForTesting
    static final String ACTION_PROJECT_AUTO_DECLINE_SETTINGS_CREATED = "bitbucket.pull.autodecline.audit.action.projectautodeclinesettingscreated";
    @VisibleForTesting
    static final String ACTION_PROJECT_AUTO_DECLINE_SETTINGS_DELETED = "bitbucket.pull.autodecline.audit.action.projectautodeclinesettingsdeleted";
    @VisibleForTesting
    static final String ACTION_PROJECT_AUTO_DECLINE_SETTINGS_UPDATED = "bitbucket.pull.autodecline.audit.action.projectautodeclinesettingsupdated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_AUTO_DECLINE_SETTINGS_CREATED = "bitbucket.pull.autodecline.audit.action.repositoryautodeclinesettingscreated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_AUTO_DECLINE_SETTINGS_DELETED = "bitbucket.pull.autodecline.audit.action.repositoryautodeclinesettingsdeleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_AUTO_DECLINE_SETTINGS_UPDATED = "bitbucket.pull.autodecline.audit.action.repositoryautodeclinesettingsupdated";
    @VisibleForTesting
    static final String ATTR_ENABLED = "bitbucket.pull.autodecline.audit.attribute.enabled";
    @VisibleForTesting
    static final String ATTR_INACTIVITY_WEEKS = "bitbucket.pull.autodecline.audit.attribute.inactivityweeks";
    private static final Map<Class<? extends AutoDeclineSettingsEvent>, String> PROJECT_ACTION_KEY_MAPPING = ImmutableMap.builder().put(AutoDeclineSettingsCreatedEvent.class, (Object)"bitbucket.pull.autodecline.audit.action.projectautodeclinesettingscreated").put(AutoDeclineSettingsDeletedEvent.class, (Object)"bitbucket.pull.autodecline.audit.action.projectautodeclinesettingsdeleted").put(AutoDeclineSettingsUpdatedEvent.class, (Object)"bitbucket.pull.autodecline.audit.action.projectautodeclinesettingsupdated").build();
    private static final Map<Class<? extends AutoDeclineSettingsEvent>, String> REPOSITORY_ACTION_KEY_MAPPING = ImmutableMap.builder().put(AutoDeclineSettingsCreatedEvent.class, (Object)"bitbucket.pull.autodecline.audit.action.repositoryautodeclinesettingscreated").put(AutoDeclineSettingsDeletedEvent.class, (Object)"bitbucket.pull.autodecline.audit.action.repositoryautodeclinesettingsdeleted").put(AutoDeclineSettingsUpdatedEvent.class, (Object)"bitbucket.pull.autodecline.audit.action.repositoryautodeclinesettingsupdated").build();
    private final AuditService auditService;

    @Autowired
    public AutoDeclineEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onAutoDeclineSettingsCreatedEvent(AutoDeclineSettingsCreatedEvent event) {
        this.auditAutoDeclineEvent(event);
    }

    @EventListener
    public void onAutoDeclineSettingsDeletedEvent(AutoDeclineSettingsDeletedEvent event) {
        this.auditAutoDeclineEvent(event);
    }

    @EventListener
    public void onAutoDeclineSettingsUpdatedEvent(AutoDeclineSettingsUpdatedEvent event) {
        this.auditAutoDeclineEvent(event);
    }

    private void auditAutoDeclineEvent(final AutoDeclineSettingsEvent event) {
        AuditEvent.Builder builder = (AuditEvent.Builder)event.getScope().accept((ScopeVisitor)new ScopeVisitor<AuditEvent.Builder>(){

            public AuditEvent.Builder visit(@Nonnull ProjectScope projectScope) {
                return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)PROJECT_ACTION_KEY_MAPPING.getOrDefault(((Object)((Object)event)).getClass(), ((Object)((Object)event)).getClass().getSimpleName())).build()).affectedObject(AuditUtils.auditResourceForProject((Project)projectScope.getProject()));
            }

            public AuditEvent.Builder visit(@Nonnull RepositoryScope repositoryScope) {
                return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)REPOSITORY_ACTION_KEY_MAPPING.getOrDefault(((Object)((Object)event)).getClass(), ((Object)((Object)event)).getClass().getSimpleName())).build()).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repositoryScope.getRepository()));
            }
        });
        if (event instanceof AutoDeclineSettingsUpdatedEvent) {
            AutoDeclineSettingsUpdatedEvent updatedEvent = (AutoDeclineSettingsUpdatedEvent)event;
            builder.addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_INACTIVITY_WEEKS).from(String.valueOf(updatedEvent.getOldInactivityWeeks())).to(String.valueOf(updatedEvent.getInactivityWeeks())).build()).addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_ENABLED).from(String.valueOf(updatedEvent.getOldEnabled())).to(String.valueOf(updatedEvent.getEnabled())).build()).build();
        } else {
            builder.extraAttribute(new AuditAttribute.Builder(ATTR_INACTIVITY_WEEKS, String.valueOf(event.getInactivityWeeks())).build()).extraAttribute(new AuditAttribute.Builder(ATTR_ENABLED, String.valueOf(event.getEnabled())).build()).build();
        }
        this.auditService.audit(builder.build());
    }
}

