/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsCreatedEvent;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsDeletedEvent;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsEvent;
import com.atlassian.stash.internal.pull.automerge.AutoMergeSettingsUpdatedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoMergeEventListener {
    @VisibleForTesting
    static final String ACTION_PROJECT_AUTO_MERGE_SETTINGS_CREATED = "bitbucket.pull.automerge.audit.action.projectautomergesettingscreated";
    @VisibleForTesting
    static final String ACTION_PROJECT_AUTO_MERGE_SETTINGS_DELETED = "bitbucket.pull.automerge.audit.action.projectautomergesettingsdeleted";
    @VisibleForTesting
    static final String ACTION_PROJECT_AUTO_MERGE_SETTINGS_UPDATED = "bitbucket.pull.automerge.audit.action.projectautomergesettingsupdated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_AUTO_MERGE_SETTINGS_CREATED = "bitbucket.pull.automerge.audit.action.repositoryautomergesettingscreated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_AUTO_MERGE_SETTINGS_DELETED = "bitbucket.pull.automerge.audit.action.repositoryautomergesettingsdeleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_AUTO_MERGE_SETTINGS_UPDATED = "bitbucket.pull.automerge.audit.action.repositoryautomergesettingsupdated";
    @VisibleForTesting
    static final String ATTR_ENABLED = "bitbucket.pull.automerge.audit.attribute.enabled";
    private static final Map<Class<? extends AutoMergeSettingsEvent>, String> PROJECT_ACTION_KEY_MAPPING = ImmutableMap.of(AutoMergeSettingsCreatedEvent.class, (Object)"bitbucket.pull.automerge.audit.action.projectautomergesettingscreated", AutoMergeSettingsDeletedEvent.class, (Object)"bitbucket.pull.automerge.audit.action.projectautomergesettingsdeleted", AutoMergeSettingsUpdatedEvent.class, (Object)"bitbucket.pull.automerge.audit.action.projectautomergesettingsupdated");
    private static final Map<Class<? extends AutoMergeSettingsEvent>, String> REPOSITORY_ACTION_KEY_MAPPING = ImmutableMap.of(AutoMergeSettingsCreatedEvent.class, (Object)"bitbucket.pull.automerge.audit.action.repositoryautomergesettingscreated", AutoMergeSettingsDeletedEvent.class, (Object)"bitbucket.pull.automerge.audit.action.repositoryautomergesettingsdeleted", AutoMergeSettingsUpdatedEvent.class, (Object)"bitbucket.pull.automerge.audit.action.repositoryautomergesettingsupdated");
    private final AuditService auditService;

    @Autowired
    public AutoMergeEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onAutoMergeSettingsCreatedEvent(AutoMergeSettingsCreatedEvent event) {
        AuditEvent auditEvent = AutoMergeEventListener.auditBuilderFor(event).extraAttribute(new AuditAttribute.Builder(ATTR_ENABLED, String.valueOf(event.getEnabled())).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onAutoMergeSettingsDeletedEvent(AutoMergeSettingsDeletedEvent event) {
        AuditEvent auditEvent = AutoMergeEventListener.auditBuilderFor(event).extraAttribute(new AuditAttribute.Builder(ATTR_ENABLED, String.valueOf(event.getEnabled())).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onAutoMergeSettingsUpdatedEvent(AutoMergeSettingsUpdatedEvent event) {
        AuditEvent auditEvent = AutoMergeEventListener.auditBuilderFor(event).addChangedValueIfDifferent(new ChangedValue.Builder(ATTR_ENABLED).from(String.valueOf(event.getOldEnabled())).to(String.valueOf(event.getEnabled())).build()).build();
        this.auditService.audit(auditEvent);
    }

    private static AuditEvent.Builder auditBuilderFor(AutoMergeSettingsEvent event) {
        final Class<?> eventClass = ((Object)((Object)event)).getClass();
        return (AuditEvent.Builder)event.getScope().accept((ScopeVisitor)new ScopeVisitor<AuditEvent.Builder>(){

            public AuditEvent.Builder visit(@Nonnull ProjectScope projectScope) {
                return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)PROJECT_ACTION_KEY_MAPPING.getOrDefault(eventClass, eventClass.getSimpleName())).build()).affectedObject(AuditUtils.auditResourceForProject((Project)projectScope.getProject()));
            }

            public AuditEvent.Builder visit(@Nonnull RepositoryScope repositoryScope) {
                return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)REPOSITORY_ACTION_KEY_MAPPING.getOrDefault(eventClass, eventClass.getSimpleName())).build()).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repositoryScope.getRepository()));
            }
        });
    }
}

