/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.branch.BranchChangedEvent;
import com.atlassian.bitbucket.event.branch.BranchCreatedEvent;
import com.atlassian.bitbucket.event.branch.BranchDeletedEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BranchChangedEventListener {
    @VisibleForTesting
    static final String ACTION_BRANCH_CREATED = "bitbucket.service.branch.audit.action.branchcreated";
    @VisibleForTesting
    static final String ACTION_BRANCH_DELETED = "bitbucket.service.branch.audit.action.branchdeleted";
    @VisibleForTesting
    static final String ATTR_BRANCH = "bitbucket.service.branch.audit.attribute.branchdeleted.branch";
    private final AuditService auditService;

    @Autowired
    public BranchChangedEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onBranchCreatedEvent(BranchCreatedEvent event) {
        this.auditBranchChangedEvent((BranchChangedEvent)event, ACTION_BRANCH_CREATED);
    }

    @EventListener
    public void onBranchDeletedEvent(BranchDeletedEvent event) {
        this.auditBranchChangedEvent((BranchChangedEvent)event, ACTION_BRANCH_DELETED);
    }

    private void auditBranchChangedEvent(BranchChangedEvent event, String action) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.repositories", (String)action).build();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository())).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_BRANCH, (String)event.getBranch().getDisplayId()).build()).build();
        this.auditService.audit(auditEvent);
    }
}

