/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.content.ArchiveRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.content.ContentArchiveEvent;
import com.atlassian.stash.internal.content.ContentArchiveFailedEvent;
import com.atlassian.stash.internal.content.ContentArchiveSuccessfulEvent;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentEventListener {
    @VisibleForTesting
    static final String ACTION_CONTENT_ARCHIVE_FAILED = "bitbucket.service.content.audit.action.contentarchivefailed";
    @VisibleForTesting
    static final String ACTION_CONTENT_ARCHIVE_SUCCESSFUL = "bitbucket.service.content.audit.action.contentarchivesuccessful";
    @VisibleForTesting
    static final String ATTR_COMMIT = "bitbucket.service.content.audit.attribute.contentarchivesuccessful.commit";
    @VisibleForTesting
    static final String ATTR_FORMAT = "bitbucket.service.content.audit.attribute.contentarchivesuccessful.format";
    @VisibleForTesting
    static final String ATTR_PATHS = "bitbucket.service.content.audit.attribute.contentarchivesuccessful.paths";
    @VisibleForTesting
    static final String ATTR_PREFIX = "bitbucket.service.content.audit.attribute.contentarchivesuccessful.prefix";
    private final AuditService auditService;

    @Autowired
    public ContentEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onContentArchiveFailedEvent(ContentArchiveFailedEvent event) {
        this.auditService.audit(ContentEventListener.toAuditEvent(event, ACTION_CONTENT_ARCHIVE_FAILED));
    }

    @EventListener
    public void onContentArchiveSuccessfulEvent(ContentArchiveSuccessfulEvent event) {
        this.auditService.audit(ContentEventListener.toAuditEvent(event, ACTION_CONTENT_ARCHIVE_SUCCESSFUL));
    }

    private static AuditEvent toAuditEvent(ContentArchiveEvent event, String action) {
        ArchiveRequest archiveRequest = event.getArchiveRequest();
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.repositories", (String)action).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)archiveRequest.getRepository())).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_COMMIT, (String)archiveRequest.getCommitId()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_FORMAT, (String)archiveRequest.getFormat().name()).build());
        if (!archiveRequest.getPaths().isEmpty()) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PATHS, (String)String.join((CharSequence)", ", archiveRequest.getPaths())).build());
        }
        archiveRequest.getPrefix().ifPresent(prefix -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PREFIX, (String)prefix).build()));
        return builder.build();
    }
}

