/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.auditing.DmzLegacyAuditEventsHelper;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class CoverageOverridingAuditService
implements AuditService {
    private final boolean isBaseLevelEnforced;
    private final AuditService delegate;
    private final DmzLegacyAuditEventsHelper auditEventsHelper;

    public CoverageOverridingAuditService(DmzLegacyAuditEventsHelper auditEventsHelper, boolean isBaseLevelEnforced, AuditService delegate) {
        this.auditEventsHelper = auditEventsHelper;
        this.isBaseLevelEnforced = isBaseLevelEnforced;
        this.delegate = delegate;
    }

    public void audit(@Nonnull AuditEvent auditEvent) {
        Objects.requireNonNull(auditEvent, "auditEvent");
        if (this.isBaseLevelEnforced && this.auditEventsHelper.isLegacyEventAboveBaseLevel(auditEvent.getActionI18nKey())) {
            auditEvent = new AuditEvent.Builder(auditEvent).level(CoverageLevel.BASE).build();
        }
        this.delegate.audit(auditEvent);
    }
}

