/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.audit.entity.EffectiveCoverageLevel;
import com.atlassian.bitbucket.dmz.auditing.DmzLegacyAuditEventsHelper;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.internal.util.PluginUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=DmzLegacyAuditEventsHelper.class)
@Component(value="legacyAuditEventsHelper")
public class DefaultLegacyAuditEventsHelper
implements DmzLegacyAuditEventsHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultLegacyAuditEventsHelper.class);
    private static final Set<String> ACTIONS_ABOVE_BASE_LEVEL;
    private static final Function<String, AuditType> UNKNOWN_ACTION_AUDIT_TYPE;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final I18nService i18nService;

    @Autowired
    public DefaultLegacyAuditEventsHelper(ApplicationPropertiesService applicationPropertiesService, I18nService i18nService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.i18nService = i18nService;
    }

    @Nonnull
    public AuditType auditTypeFor(@Nonnull String action) {
        Objects.requireNonNull(action, "action");
        AuditType auditType = AuditTypeMapProvider.eventToType.get(action);
        if (auditType == null) {
            String logMessage = "The action [{}] couldn't be mapped to an AuditType. Falling back to default AuditType.";
            if (PluginUtils.isAtlassianDevMode()) {
                log.warn(logMessage, (Object)action);
            } else {
                log.debug(logMessage, (Object)action);
            }
            auditType = UNKNOWN_ACTION_AUDIT_TYPE.apply(action);
        }
        return this.translate(auditType);
    }

    public boolean isLegacyEventAboveBaseLevel(@Nonnull String actionI18nKey) {
        return ACTIONS_ABOVE_BASE_LEVEL.contains(Objects.requireNonNull(actionI18nKey, "actionI18nKey"));
    }

    private AuditType translate(AuditType auditType) {
        Locale locale = this.applicationPropertiesService.getLocale();
        return AuditType.builder((AuditType)auditType).withActionTranslation(this.i18nService.getMessage(locale, auditType.getActionI18nKey(), new Object[0])).withCategoryTranslation(this.i18nService.getMessage(locale, auditType.getCategoryI18nKey(), new Object[0])).build();
    }

    static {
        UNKNOWN_ACTION_AUDIT_TYPE = action -> AuditType.fromI18nKeys((CoverageArea)CoverageArea.ECOSYSTEM, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.unknown", (String)action).build();
        ACTIONS_ABOVE_BASE_LEVEL = AuditTypeMapProvider.eventToType.values().stream().filter(auditType -> !EffectiveCoverageLevel.BASE.shouldAllow(auditType.getLevel())).map(AuditType::getActionI18nKey).collect(Collectors.toSet());
    }

    private static class AuditTypeMapProvider {
        private static final Map<String, AuditType> eventToType = ImmutableMap.builder().put((Object)"AllApproversMergeCheckConfigChangedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"AllApproversMergeCheckConfigChangedEvent").build()).put((Object)"RequiredApproversChangedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"RequiredApproversChangedEvent").build()).put((Object)"RequiredBuildsChangedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"RequiredBuildsChangedEvent").build()).put((Object)"RequiredBuildsExtendedSettingsChangedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"RequiredBuildsExtendedSettingsChangedEvent").build()).put((Object)"BranchModelConfigurationCreatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.branch.audit.action.branchmodelconfigurationcreated").build()).put((Object)"BranchModelConfigurationDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.branch.audit.action.branchmodelconfigurationdeleted").build()).put((Object)"BranchModelConfigurationUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.branch.audit.action.branchmodelconfigurationupdated").build()).put((Object)"BranchModelConfigurationProjectCreatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"BranchModelConfigurationProjectCreatedEvent").build()).put((Object)"BranchModelConfigurationProjectDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"BranchModelConfigurationProjectDeletedEvent").build()).put((Object)"BranchModelConfigurationProjectUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"BranchModelConfigurationProjectUpdatedEvent").build()).put((Object)"BranchModelConfigurationRepositoryCreatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"BranchModelConfigurationRepositoryCreatedEvent").build()).put((Object)"BranchModelConfigurationRepositoryDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"BranchModelConfigurationRepositoryDeletedEvent").build()).put((Object)"BranchModelConfigurationRepositoryUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"BranchModelConfigurationRepositoryUpdatedEvent").build()).put((Object)"AutoMergeConfigUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.cascadingmerge.audit.action.cascadingmergeconfigupdated").build()).put((Object)"AutoMergeProjectConfigUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"CascadingMergeProjectConfigUpdatedEvent").build()).put((Object)"AutoMergeRepositoryConfigUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"CascadingMergeRepositoryConfigUpdatedEvent").build()).put((Object)"InsightReportConditionAddedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.codeinsights.audit.action.insightreportconditionadded").build()).put((Object)"InsightReportConditionDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.codeinsights.audit.action.insightreportconditiondeleted").build()).put((Object)"InsightReportConditionUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.codeinsights.audit.action.insightreportconditionupdated").build()).put((Object)"PullRequestConditionCreatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.defaultreviewers.audit.action.pullrequestconditioncreated").build()).put((Object)"PullRequestConditionDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.defaultreviewers.audit.action.pullrequestconditiondeleted").build()).put((Object)"PullRequestConditionUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.defaultreviewers.audit.action.pullrequestconditionupdated").build()).put((Object)"RefRestrictionAddedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.branch.permission.audit.action.refrestrictionadded").build()).put((Object)"RefRestrictionDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.branch.permission.audit.action.refrestrictiondeleted").build()).put((Object)"RefRestrictionUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.branch.permission.audit.action.refrestrictionupdated").build()).put((Object)"RestrictedRefAddedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"RestrictedRefAddedEvent").build()).put((Object)"RestrictedRefRemovedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"RestrictedRefRemovedEvent").build()).put((Object)"RestrictedRefUpdatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"RestrictedRefUpdatedEvent").build()).put((Object)"SshKeyAccessGrantedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"SshKeyAccessGrantedEvent").build()).put((Object)"SshKeyAccessRevokedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"SshKeyAccessRevokedEvent").build()).put((Object)"AuthenticationFailureEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.authentication", (String)"bitbucket.service.user.audit.action.authenticationfailure").build()).put((Object)"AuthenticationSuccessEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.authentication", (String)"bitbucket.service.user.audit.action.authenticationsuccess").build()).put((Object)"SshAuthenticationSuccessEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.authentication", (String)"SshAuthenticationSuccessEvent").build()).put((Object)"ProjectPermissionGrantedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.projectpermissiongranted").build()).put((Object)"ProjectPermissionRevokedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.projectpermissionrevoked").build()).put((Object)"ProjectPermissionModifiedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.projectpermissionmodified").build()).put((Object)"ProjectPermissionGrantRequestedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.projectpermissiongrantrequested").build()).put((Object)"ProjectPermissionModificationRequestedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.projectpermissionmodificationrequested").build()).put((Object)"ProjectPermissionRevocationRequestedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.projectpermissionrevocationrequested").build()).put((Object)"RepositoryPermissionGrantedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.repositorypermissiongranted").build()).put((Object)"RepositoryPermissionRevokedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.repositorypermissionrevoked").build()).put((Object)"RepositoryPermissionModifiedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.repositorypermissionmodified").build()).put((Object)"RepositoryPermissionGrantRequestedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.repositorypermissiongrantrequested").build()).put((Object)"RepositoryPermissionModificationRequestedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.repositorypermissionmodificationrequested").build()).put((Object)"RepositoryPermissionRevocationRequestedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)"bitbucket.service.user.audit.action.repositorypermissionrevocationrequested").build()).put((Object)"ProjectCreatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.service.project.audit.action.projectcreated").build()).put((Object)"ProjectImportedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.service.project.audit.action.projectimported").build()).put((Object)"ProjectModifiedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.service.project.audit.action.projectmodified").build()).put((Object)"PullRequestDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.pullrequests", (String)"bitbucket.service.pullrequest.audit.action.pullrequestdeleted").build()).put((Object)"RepositoryCreatedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositorycreated").build()).put((Object)"RepositoryModifiedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositorymodified").build()).put((Object)"RepositoryDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositorydeleted").build()).put((Object)"RepositoryCloneEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositoryclone").build()).put((Object)"RepositoryForkedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositoryforked").build()).put((Object)"RepositoryImportedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositoryimported").build()).put((Object)"RepositoryOtherReadEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositoryotherread").build()).put((Object)"RepositoryOtherWriteEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositoryotherwrite").build()).put((Object)"RepositoryPullEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositorypull").build()).put((Object)"RepositoryPushEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.repositories", (String)"bitbucket.service.repository.audit.action.repositorypush").build()).put((Object)"RepositoryHookDisabledEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.service.repository.audit.action.repositoryhookdisabled").build()).put((Object)"RepositoryHookDeletedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.service.repository.audit.action.repositoryhookdeleted").build()).put((Object)"RepositoryHookEnabledEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.service.repository.audit.action.repositoryhookenabled").build()).put((Object)"RepositoryHookSettingsChangedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.service.repository.audit.action.repositoryhooksettingschanged").build()).put((Object)"PluginContainerUnavailableEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.apps", (String)"bitbucket.service.plugincontainer.audit.action.plugincontainerunavailable").build()).put((Object)"PluginModuleDisabledEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.apps", (String)"bitbucket.service.pluginmodule.audit.action.pluginmoduledisabled").build()).put((Object)"PluginModuleEnabledEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.apps", (String)"bitbucket.service.pluginmodule.audit.action.pluginmoduleenabled").build()).put((Object)"PluginModuleAvailableEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.apps", (String)"bitbucket.service.pluginmodule.audit.action.pluginmoduleavailable").build()).put((Object)"PluginModuleUnavailableEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.apps", (String)"bitbucket.service.pluginmodule.audit.action.pluginmoduleunavailable").build()).put((Object)"PluginFrameworkStartedEvent", (Object)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.apps", (String)"bitbucket.service.pluginframework.audit.action.pluginframeworkstarted").build()).build();

        private AuditTypeMapProvider() {
        }
    }
}

