/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.compare.DiffSuccessfulEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DiffCompareEventListener {
    @VisibleForTesting
    static final String ACTION_DIFF_SUCCESSFUL = "bitbucket.service.branch.audit.action.diffsuccessful";
    @VisibleForTesting
    static final String ATTR_FROM_REF = "bitbucket.service.branch.audit.attribute.diffsuccessful.from";
    @VisibleForTesting
    static final String ATTR_TO_REF = "bitbucket.service.branch.audit.attribute.diffsuccessful.to";
    private final AuditService auditService;

    @Autowired
    public DiffCompareEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onDiffSuccessfulEvent(DiffSuccessfulEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.repositories", (String)ACTION_DIFF_SUCCESSFUL).build();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getFromRef().getRepository())).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_FROM_REF, (String)event.getFromRef().getId()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TO_REF, (String)event.getToRef().getId()).build()).build();
        this.auditService.audit(auditEvent);
    }
}

