/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.hook.script.HookScriptConfigurationRemovedEvent;
import com.atlassian.bitbucket.hook.script.HookScriptConfigurationSetEvent;
import com.atlassian.bitbucket.hook.script.HookScriptCreatedEvent;
import com.atlassian.bitbucket.hook.script.HookScriptDeletedEvent;
import com.atlassian.bitbucket.hook.script.HookScriptEvent;
import com.atlassian.bitbucket.hook.script.HookScriptUpdatedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.hook.script.HookScriptsDeletedByPluginKeyEvent;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HookScriptEventListener {
    private static final String AUDIT_I18N_KEY_PREFIX = "bitbucket.service.hook.script.audit.";
    @VisibleForTesting
    static final String ATTR_DELETED_COUNT = "bitbucket.service.hook.script.audit.attribute.hookscriptsdeletedbypluginkey.deletedcount";
    @VisibleForTesting
    static final String ATTR_TRIGGER_IDS = "bitbucket.service.hook.script.audit.attribute.hookscriptconfigurationset.triggerids";
    private static final String AUDIT_ACTION_PREFIX = "bitbucket.service.hook.script.audit.action.";
    @VisibleForTesting
    static final String ACTION_HOOK_SCRIPT_CONFIGURATION_REMOVED = "bitbucket.service.hook.script.audit.action.hookscriptconfigurationremoved";
    @VisibleForTesting
    static final String ACTION_HOOK_SCRIPT_CONFIGURATION_SET = "bitbucket.service.hook.script.audit.action.hookscriptconfigurationset";
    @VisibleForTesting
    static final String ACTION_HOOK_SCRIPT_CREATED = "bitbucket.service.hook.script.audit.action.hookscriptcreated";
    @VisibleForTesting
    static final String ACTION_HOOK_SCRIPT_DELETED = "bitbucket.service.hook.script.audit.action.hookscriptdeleted";
    @VisibleForTesting
    static final String ACTION_HOOK_SCRIPT_UPDATED = "bitbucket.service.hook.script.audit.action.hookscriptupdated";
    @VisibleForTesting
    static final String ACTION_HOOK_SCRIPTS_DELETED_BY_PLUGIN_KEY = "bitbucket.service.hook.script.audit.action.hookscriptsdeletedbypluginkey";
    private static final String AUDIT_ATTR_PREFIX = "bitbucket.service.hook.script.audit.attribute.hookscript.";
    @VisibleForTesting
    static final String ATTR_DESCRIPTION = "bitbucket.service.hook.script.audit.attribute.hookscript.description";
    @VisibleForTesting
    static final String ATTR_NAME = "bitbucket.service.hook.script.audit.attribute.hookscript.name";
    @VisibleForTesting
    static final String ATTR_PLUGIN_KEY = "bitbucket.service.hook.script.audit.attribute.hookscript.pluginkey";
    @VisibleForTesting
    static final String ATTR_TYPE = "bitbucket.service.hook.script.audit.attribute.hookscript.type";
    private final AuditService auditService;

    @Autowired
    public HookScriptEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onHookScriptConfigurationSet(@Nonnull HookScriptConfigurationSetEvent event) {
        Set whiteListedTriggers = Arrays.stream(StandardRepositoryHookTrigger.values()).map(StandardRepositoryHookTrigger::getId).collect(Collectors.toSet());
        whiteListedTriggers.add("git-rebase");
        String triggerIds = event.getTriggerIds().stream().filter(Objects::nonNull).map(trigger -> whiteListedTriggers.contains(trigger) ? trigger : "unknown").collect(Collectors.joining(", "));
        this.auditService.audit(HookScriptEventListener.toAuditEventBuilder((HookScriptEvent)event, event.getScope(), ACTION_HOOK_SCRIPT_CONFIGURATION_SET).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TRIGGER_IDS, (String)triggerIds).build()).build());
    }

    @EventListener
    public void onHookScriptConfigurationRemoved(@Nonnull HookScriptConfigurationRemovedEvent event) {
        this.auditService.audit(HookScriptEventListener.toAuditEventBuilder((HookScriptEvent)event, event.getScope(), ACTION_HOOK_SCRIPT_CONFIGURATION_REMOVED).build());
    }

    @EventListener
    public void onHookScriptCreated(@Nonnull HookScriptCreatedEvent event) {
        this.auditService.audit(HookScriptEventListener.toAuditEventBuilder((HookScriptEvent)event, (Scope)new GlobalScope(), ACTION_HOOK_SCRIPT_CREATED).build());
    }

    @EventListener
    public void onHookScriptDeleted(@Nonnull HookScriptDeletedEvent event) {
        this.auditService.audit(HookScriptEventListener.toAuditEventBuilder((HookScriptEvent)event, (Scope)new GlobalScope(), ACTION_HOOK_SCRIPT_DELETED).build());
    }

    @EventListener
    public void onHookScriptUpdated(@Nonnull HookScriptUpdatedEvent event) {
        this.auditService.audit(HookScriptEventListener.toAuditEventBuilder((HookScriptEvent)event, (Scope)new GlobalScope(), ACTION_HOOK_SCRIPT_UPDATED).build());
    }

    @EventListener
    public void onHookScriptsDeletedByPluginKey(@Nonnull HookScriptsDeletedByPluginKeyEvent event) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)ACTION_HOOK_SCRIPTS_DELETED_BY_PLUGIN_KEY).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PLUGIN_KEY, (String)event.getPluginKey()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DELETED_COUNT, (String)String.valueOf(event.getCount())).build());
        this.auditService.audit(builder.build());
    }

    private static void addAttributeOrChangedValue(AuditEvent.Builder builder, String key, String oldValue, String newValue) {
        if (Objects.equals(oldValue, newValue)) {
            if (newValue != null) {
                builder.extraAttribute(AuditAttribute.fromI18nKeys((String)key, (String)newValue).build());
            }
        } else {
            builder.changedValue(ChangedValue.fromI18nKeys((String)key).from(oldValue).to(newValue).build());
        }
    }

    private static void addAttributesOrChangedValues(HookScriptEvent event, AuditEvent.Builder builder) {
        HookScript newHookScript;
        HookScript oldHookScript = newHookScript = event.getHookScript();
        if (event instanceof HookScriptUpdatedEvent && ((HookScriptUpdatedEvent)event).getOldHookScript() != null) {
            HookScriptUpdatedEvent updatedEvent = (HookScriptUpdatedEvent)event;
            oldHookScript = Objects.requireNonNull(updatedEvent.getOldHookScript());
        }
        HookScriptEventListener.addAttributeOrChangedValue(builder, ATTR_NAME, oldHookScript.getName(), newHookScript.getName());
        HookScriptEventListener.addAttributeOrChangedValue(builder, ATTR_DESCRIPTION, oldHookScript.getDescription().orElse(null), newHookScript.getDescription().orElse(null));
        HookScriptEventListener.addAttributeOrChangedValue(builder, ATTR_PLUGIN_KEY, oldHookScript.getPluginKey(), newHookScript.getPluginKey());
        HookScriptEventListener.addAttributeOrChangedValue(builder, ATTR_TYPE, oldHookScript.getType().name(), newHookScript.getType().name());
    }

    private static AuditEvent.Builder toAuditEventBuilder(HookScriptEvent event, Scope scope, String actionI18nKey) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)actionI18nKey).build();
        final AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType);
        HookScriptEventListener.addAttributesOrChangedValues(event, builder);
        return (AuditEvent.Builder)scope.accept((ScopeVisitor)new ScopeVisitor<AuditEvent.Builder>(){

            public AuditEvent.Builder visit(@Nonnull GlobalScope scope) {
                return builder;
            }

            public AuditEvent.Builder visit(@Nonnull ProjectScope scope) {
                return builder.affectedObject(AuditUtils.auditResourceForProject((Project)scope.getProject()));
            }

            public AuditEvent.Builder visit(@Nonnull RepositoryScope scope) {
                return builder.appendAffectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository()));
            }
        });
    }
}

