/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.mesh.MeshNodeUnregisteredEvent;
import com.atlassian.bitbucket.event.mesh.AbstractMeshNodeEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeRegisteredEvent;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MeshEventListener {
    private static final String AUDIT_I18N_KEY_PREFIX = "bitbucket.service.mesh.audit.";
    @VisibleForTesting
    static final String ACTION_NODE_REGISTERED = "bitbucket.service.mesh.audit.action.node.registered";
    @VisibleForTesting
    static final String ACTION_NODE_UNREGISTERED = "bitbucket.service.mesh.audit.action.node.unregistered";
    @VisibleForTesting
    static final String ATTR_NODE_AVAILABILITY_ZONE = "bitbucket.service.mesh.audit.attribute.node.availability-zone";
    @VisibleForTesting
    static final String ATTR_NODE_ID = "bitbucket.service.mesh.audit.attribute.node.id";
    @VisibleForTesting
    static final String ATTR_NODE_NAME = "bitbucket.service.mesh.audit.attribute.node.name";
    @VisibleForTesting
    static final String ATTR_NODE_URL = "bitbucket.service.mesh.audit.attribute.node.url";
    private final AuditService auditService;

    @Autowired
    public MeshEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onMeshNodeRegisteredEvent(MeshNodeRegisteredEvent event) {
        this.auditMeshNodeEvent((MeshNodeEvent)event, ACTION_NODE_REGISTERED);
    }

    @EventListener
    public void onMeshNodeUnregisteredEvent(MeshNodeUnregisteredEvent event) {
        this.auditMeshNodeEvent((MeshNodeEvent)event, ACTION_NODE_UNREGISTERED);
    }

    private void auditMeshNodeEvent(MeshNodeEvent event, String action) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)action).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_NODE_ID, (String)Long.toString(event.getNodeId())).build());
        if (event instanceof AbstractMeshNodeEvent) {
            AbstractMeshNodeEvent nodeEvent = (AbstractMeshNodeEvent)event;
            MeshNode node = nodeEvent.getNode();
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_NODE_NAME, (String)node.getName()).build());
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_NODE_URL, (String)node.getRpcUrl()).build());
            if (node.hasAvailabilityZone()) {
                builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_NODE_AVAILABILITY_ZONE, (String)node.getAvailabilityZone()).build());
            }
        }
        this.auditService.audit(builder.build());
    }
}

