/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.user.AuthorizationFailureEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionGrantRequestedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionModificationRequestedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionRevocationRequestedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionRevokedEvent;
import com.atlassian.bitbucket.event.permission.PermissionEvent;
import com.atlassian.bitbucket.event.permission.PermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionGrantRequestedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionModificationRequestedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionRevocationRequestedEvent;
import com.atlassian.bitbucket.event.permission.ProjectPermissionRevokedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionGrantRequestedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionModificationRequestedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionRevocationRequestedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionRevokedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionEventListener {
    private static final String AUDIT_KEYS_PREFIX = "bitbucket.service.user.audit.";
    @VisibleForTesting
    static final String ATTR_ACTION = "bitbucket.service.user.audit.attribute.authorizationfailure.action";
    @VisibleForTesting
    static final String ATTR_GROUP = "bitbucket.service.user.audit.attribute.permission.group";
    @VisibleForTesting
    static final String ATTR_PERMISSION = "bitbucket.service.user.audit.attribute.permission.permission";
    private static final String ACTION_PERMISSION_EVENT_PREFIX = "bitbucket.service.user.audit.action.";
    @VisibleForTesting
    static final String ACTION_AUTHORIZATION_FAILURE = "bitbucket.service.user.audit.action.authorizationfailure";
    private static final Map<Class<?>, String> PERMISSION_ACTION_KEY_MAPPING = ImmutableMap.builder().put(GlobalPermissionGrantRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.globalpermissiongrantrequested").put(GlobalPermissionGrantedEvent.class, (Object)"bitbucket.service.user.audit.action.globalpermissiongranted").put(GlobalPermissionModificationRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.globalpermissionmodificationrequested").put(GlobalPermissionModifiedEvent.class, (Object)"bitbucket.service.user.audit.action.globalpermissionmodified").put(GlobalPermissionRevocationRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.globalpermissionrevocationrequested").put(GlobalPermissionRevokedEvent.class, (Object)"bitbucket.service.user.audit.action.globalpermissionrevoked").put(ProjectPermissionGrantRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.projectpermissiongrantrequested").put(ProjectPermissionGrantedEvent.class, (Object)"bitbucket.service.user.audit.action.projectpermissiongranted").put(ProjectPermissionModificationRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.projectpermissionmodificationrequested").put(ProjectPermissionModifiedEvent.class, (Object)"bitbucket.service.user.audit.action.projectpermissionmodified").put(ProjectPermissionRevocationRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.projectpermissionrevocationrequested").put(ProjectPermissionRevokedEvent.class, (Object)"bitbucket.service.user.audit.action.projectpermissionrevoked").put(RepositoryPermissionGrantRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.repositorypermissiongrantrequested").put(RepositoryPermissionGrantedEvent.class, (Object)"bitbucket.service.user.audit.action.repositorypermissiongranted").put(RepositoryPermissionModificationRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.repositorypermissionmodificationrequested").put(RepositoryPermissionModifiedEvent.class, (Object)"bitbucket.service.user.audit.action.repositorypermissionmodified").put(RepositoryPermissionRevocationRequestedEvent.class, (Object)"bitbucket.service.user.audit.action.repositorypermissionrevocationrequested").put(RepositoryPermissionRevokedEvent.class, (Object)"bitbucket.service.user.audit.action.repositorypermissionrevoked").build();
    private final AuditService auditService;
    private final RequestManager requestManager;

    @Autowired
    public PermissionEventListener(AuditService auditService, RequestManager requestManager) {
        this.auditService = auditService;
        this.requestManager = requestManager;
    }

    @EventListener
    public void onAuthorizationFailure(AuthorizationFailureEvent event) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.security", (String)ACTION_AUTHORIZATION_FAILURE).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType);
        RequestMetadata requestMetadata = this.requestManager.getRequestMetadata();
        if (requestMetadata != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ACTION, (String)StringUtils.unwrap((String)requestMetadata.getAction(), (char)'\"')).build());
        }
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onGlobalPermission(GlobalPermissionEvent event) {
        this.auditService.audit(PermissionEventListener.toAuditEventBuilder((PermissionEvent)event, new AuditResource[0]).build());
    }

    @EventListener
    public void onProjectPermission(ProjectPermissionEvent event) {
        Project project = event.getProject();
        this.auditService.audit(PermissionEventListener.toAuditEventBuilder((PermissionEvent)event, AuditUtils.auditResourceForProject((Project)project)).build());
    }

    @EventListener
    public void onRepositoryPermission(RepositoryPermissionEvent event) {
        Repository repository = event.getRepository();
        this.auditService.audit(PermissionEventListener.toAuditEventBuilder((PermissionEvent)event, AuditUtils.auditResourceForProject((Project)repository.getProject()), AuditUtils.auditResourceForRepository((Repository)repository)).build());
    }

    private static AuditEvent.Builder toAuditEventBuilder(PermissionEvent event, AuditResource ... resources) {
        String actionI18nKey = PERMISSION_ACTION_KEY_MAPPING.getOrDefault(event.getClass(), event.getClass().getSimpleName());
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.permissions", (String)actionI18nKey).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).appendAffectedObjects(Arrays.asList(resources));
        ApplicationUser user = event.getAffectedUser();
        if (user != null) {
            builder.affectedObject(AuditUtils.auditResourceForUser((ApplicationUser)user));
        }
        if (event.getAffectedGroup() != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_GROUP, (String)event.getAffectedGroup()).build());
        }
        if (event instanceof PermissionModifiedEvent) {
            PermissionModifiedEvent modifiedEvent = (PermissionModifiedEvent)event;
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_PERMISSION).from(modifiedEvent.getOldValue().name()).to(modifiedEvent.getNewValue().name()).build());
        } else {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PERMISSION, (String)event.getPermission().name()).build());
        }
        return builder;
    }
}

