/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.project.ProjectAvatarUpdatedEvent;
import com.atlassian.bitbucket.event.project.ProjectCreatedEvent;
import com.atlassian.bitbucket.event.project.ProjectCreationRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectEvent;
import com.atlassian.bitbucket.event.project.ProjectImportedEvent;
import com.atlassian.bitbucket.event.project.ProjectModificationRequestedEvent;
import com.atlassian.bitbucket.event.project.ProjectModifiedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectEventListener {
    private static final String AUDIT_ACTION_KEY_PREFIX = "bitbucket.service.project.audit.action.";
    private static final String AUDIT_CHANGED_VALUE_KEY_PREFIX = "bitbucket.service.project.audit.changedvalue.projectmodified.";
    @VisibleForTesting
    static final Map<Class<?>, String> I18N_ACTION_KEYS = ImmutableMap.builder().put(ProjectAvatarUpdatedEvent.class, (Object)"bitbucket.service.project.audit.action.projectavatarupdated").put(ProjectCreatedEvent.class, (Object)"bitbucket.service.project.audit.action.projectcreated").put(ProjectCreationRequestedEvent.class, (Object)"bitbucket.service.project.audit.action.projectcreationrequested").put(ProjectDeletedEvent.class, (Object)"bitbucket.service.project.audit.action.projectdeleted").put(ProjectDeletionRequestedEvent.class, (Object)"bitbucket.service.project.audit.action.projectdeletionrequested").put(ProjectImportedEvent.class, (Object)"bitbucket.service.project.audit.action.projectimported").put(ProjectModificationRequestedEvent.class, (Object)"bitbucket.service.project.audit.action.projectmodificationrequested").put(ProjectModifiedEvent.class, (Object)"bitbucket.service.project.audit.action.projectmodified").build();
    @VisibleForTesting
    static final String KEY_PROJECT_DESCRIPTION = "bitbucket.service.project.audit.changedvalue.projectmodified.description";
    @VisibleForTesting
    static final String KEY_PROJECT_IS_PUBLIC = "bitbucket.service.project.audit.changedvalue.projectmodified.public";
    @VisibleForTesting
    static final String KEY_PROJECT_KEY = "bitbucket.service.project.audit.changedvalue.projectmodified.key";
    @VisibleForTesting
    static final String KEY_PROJECT_NAME = "bitbucket.service.project.audit.changedvalue.projectmodified.name";
    private final AuditService auditService;

    @Autowired
    public ProjectEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onProjectEvent(ProjectEvent event) {
        AuditEvent.Builder builder = ProjectEventListener.getAuditEventBuilder(event);
        if (event instanceof ProjectModifiedEvent) {
            ProjectModifiedEvent e = (ProjectModifiedEvent)event;
            Project oldProject = e.getOldValue();
            Project newProject = e.getNewValue();
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PROJECT_KEY).from(oldProject.getKey()).to(newProject.getKey()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PROJECT_NAME).from(oldProject.getName()).to(newProject.getName()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PROJECT_DESCRIPTION).from(oldProject.getDescription()).to(newProject.getDescription()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PROJECT_IS_PUBLIC).from(String.valueOf(oldProject.isPublic())).to(String.valueOf(newProject.isPublic())).build()).build();
        }
        this.auditService.audit(builder.build());
    }

    private static AuditEvent.Builder getAuditEventBuilder(ProjectEvent event) {
        Class<?> eventClass = event.getClass();
        return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)I18N_ACTION_KEYS.getOrDefault(eventClass, eventClass.getSimpleName())).build()).affectedObject(AuditUtils.auditResourceForProject((Project)event.getProject()));
    }
}

