/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.event.pull.PullRequestAutoMergeCancelledEvent;
import com.atlassian.bitbucket.event.pull.PullRequestAutoMergeRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentAddedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentEditedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentRepliedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantStatusUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantsUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.AutoMergeCancelledReason;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.pull.GitPullRequestRebasedEvent;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.pull.PullRequestMergeConfigBulkDeletedEvent;
import com.atlassian.stash.internal.pull.PullRequestMergeConfigDeletedEvent;
import com.atlassian.stash.internal.pull.PullRequestMergeConfigEvent;
import com.atlassian.stash.internal.pull.PullRequestMergeConfigUpdatedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestEventListener {
    @VisibleForTesting
    static final String ACTION_AUTO_MERGE_CANCELED = "bitbucket.service.pullrequest.audit.action.pullrequestautomergecanceled";
    @VisibleForTesting
    static final String ACTION_AUTO_MERGE_REQUESTED = "bitbucket.service.pullrequest.audit.action.pullrequestautomergerequested";
    @VisibleForTesting
    static final String ACTION_COMMENT_ADDED = "bitbucket.service.pullrequest.audit.action.pullrequestcommentadded";
    @VisibleForTesting
    static final String ACTION_COMMENT_DELETED = "bitbucket.service.pullrequest.audit.action.pullrequestcommentdeleted";
    @VisibleForTesting
    static final String ACTION_COMMENT_EDITED = "bitbucket.service.pullrequest.audit.action.pullrequestcommentedited";
    @VisibleForTesting
    static final String ACTION_COMMENT_REPLIED = "bitbucket.service.pullrequest.audit.action.pullrequestcommentreplied";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_DECLINED = "bitbucket.service.pullrequest.audit.action.pullrequestdeclined";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_DELETED = "bitbucket.service.pullrequest.audit.action.pullrequestdeleted";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_DRAFT_UPDATED = "bitbucket.service.pullrequest.audit.action.pullrequestdraftupdated";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_MERGED = "bitbucket.service.pullrequest.audit.action.pullrequestmerged";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_OPENED = "bitbucket.service.pullrequest.audit.action.pullrequestopened";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_OPEN_REQUESTED = "bitbucket.service.pullrequest.audit.action.pullrequestopenrequested";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_PARTICIPANTS_UPDATED = "bitbucket.service.pullrequest.audit.action.pullrequestparticipantsupdatedevent";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_PARTICIPANT_APPROVED = "bitbucket.service.pullrequest.audit.action.pullrequestparticipantapproved";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_PARTICIPANT_REVIEWED = "bitbucket.service.pullrequest.audit.action.pullrequestparticipantreviewed";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_PARTICIPANT_UNAPPROVED = "bitbucket.service.pullrequest.audit.action.pullrequestparticipantunapproved";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_REBASED = "bitbucket.service.pullrequest.audit.action.gitpullrequestrebased";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_REOPENED = "bitbucket.service.pullrequest.audit.action.pullrequestreopened";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_REVIEWERS_UPDATED = "bitbucket.service.pullrequest.audit.action.pullrequestreviewersupdated";
    @VisibleForTesting
    static final String ACTION_TASK_ADDED = "bitbucket.service.pullrequest.audit.action.pullrequesttaskadded";
    @VisibleForTesting
    static final String ACTION_TASK_DELETED = "bitbucket.service.pullrequest.audit.action.pullrequesttaskdeleted";
    @VisibleForTesting
    static final String ACTION_TASK_EDITED = "bitbucket.service.pullrequest.audit.action.pullrequesttaskedited";
    @VisibleForTesting
    static final String ATTR_AUTO_MERGED_BY = "bitbucket.service.pullrequest.audit.attribute.pullrequestmerged.automergedby";
    @VisibleForTesting
    static final String ATTR_CANCELATION_REASON = "bitbucket.service.pullrequest.audit.attribute.pullrequest.automerge.cancelationreason";
    @VisibleForTesting
    static final String ATTR_DRAFT = "bitbucket.service.pullrequest.audit.attribute.pullrequest.draft";
    @VisibleForTesting
    static final String ATTR_FROM_REF = "bitbucket.service.pullrequest.audit.attribute.pullrequest.fromref";
    @VisibleForTesting
    static final String ATTR_MERGE_COMMIT = "bitbucket.service.pullrequest.audit.attribute.pullrequestmerged.mergecommit";
    @VisibleForTesting
    static final String ATTR_MERGE_CONFIGS_DELETED = "bitbucket.service.pullrequest.audit.attribute.pullrequest.configs.deleted";
    @VisibleForTesting
    static final String ATTR_MESSAGE = "bitbucket.service.pullrequest.audit.attribute.pullrequestmerged.message";
    @VisibleForTesting
    static final String ATTR_SCM = "bitbucket.service.pullrequest.audit.attribute.pullrequesttaskedited.scm";
    @VisibleForTesting
    static final String ATTR_TEXT = "bitbucket.service.pullrequest.audit.attribute.pullrequesttaskedited.text";
    @VisibleForTesting
    static final String ATTR_TO_REF = "bitbucket.service.pullrequest.audit.attribute.pullrequest.toref";
    @VisibleForTesting
    static final String KEY_COMMIT = "bitbucket.service.pullrequest.audit.changedvalue.gitpullrequestrebased.commit";
    @VisibleForTesting
    static final String KEY_COMMIT_SUMMARIES = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestmergeconfigupdated.commitsummaries";
    @VisibleForTesting
    static final String KEY_COMMIT_TEMPLATE_BODY = "bitbucket.service.pullrequest.audit.changedvalue.commitmessagetemplate.body";
    @VisibleForTesting
    static final String KEY_COMMIT_TEMPLATE_ENABLED = "bitbucket.service.pullrequest.audit.changedvalue.commitmessagetemplate.enabled";
    @VisibleForTesting
    static final String KEY_COMMIT_TEMPLATE_TITLE = "bitbucket.service.pullrequest.audit.changedvalue.commitmessagetemplate.title";
    @VisibleForTesting
    static final String KEY_CONFIGURATION_LEVEL = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestmergeconfigupdated.configurationlevel";
    @VisibleForTesting
    static final String KEY_DEFAULT_STRATEGY_ID = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestmergeconfigupdated.defaultstrategyid";
    @VisibleForTesting
    static final String KEY_ENABLED_STRATEGY_IDS = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestmergeconfigupdated.enabledstrategyids";
    @VisibleForTesting
    static final String KEY_PARTICIPANTS = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestparticipantsupdated.participants";
    @VisibleForTesting
    static final String KEY_PARTICIPANT_STATUS = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestparticipantstatusupdated.status";
    @VisibleForTesting
    static final String KEY_REVIEWERS = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestreviewersupdated.reviewers";
    @VisibleForTesting
    static final String KEY_SEVERITY = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestcomment.severity";
    @VisibleForTesting
    static final String KEY_STATE = "bitbucket.service.pullrequest.audit.changedvalue.pullrequestcommentedited.state";
    private static final int MAX_COMMENT_CHARACTERS_LENGTH = 1800;
    private final AuditService auditService;
    private final FeatureManager featureManager;

    @Autowired
    public PullRequestEventListener(AuditService auditService, FeatureManager featureManager) {
        this.auditService = auditService;
        this.featureManager = featureManager;
    }

    @EventListener
    public void onPullRequestAutoMergeCanceled(PullRequestAutoMergeCancelledEvent event) {
        AuditEvent.Builder builder = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_AUTO_MERGE_CANCELED);
        AutoMergeCancelledReason cancelReason = event.getReason();
        if (cancelReason != AutoMergeCancelledReason.USER_CANCELLED_REQUEST) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_CANCELATION_REASON, (String)cancelReason.toString()).build());
        }
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onPullRequestAutoMergeRequested(PullRequestAutoMergeRequestedEvent event) {
        this.auditMinimalPullRequestEvent((PullRequestEvent)event, ACTION_AUTO_MERGE_REQUESTED);
    }

    @EventListener
    public void onPullRequestCommentAdded(PullRequestCommentAddedEvent event) {
        ImmutableList changedValues = ImmutableList.of((Object)ChangedValue.fromI18nKeys((String)ATTR_TEXT).to(PullRequestEventListener.truncateComment(event.getComment().getText())).build(), (Object)ChangedValue.fromI18nKeys((String)KEY_SEVERITY).to(event.getComment().getSeverity().name()).build());
        this.auditService.audit(PullRequestEventListener.pullRequestCommentAuditEvent(event.getPullRequest(), PullRequestEventListener.getAction((PullRequestCommentEvent)event), (List<ChangedValue>)changedValues));
    }

    @EventListener
    public void onPullRequestCommentDeleted(PullRequestCommentDeletedEvent event) {
        ChangedValue changedValue = ChangedValue.fromI18nKeys((String)ATTR_TEXT).from(PullRequestEventListener.truncateComment(event.getComment().getText())).build();
        this.auditService.audit(PullRequestEventListener.pullRequestCommentAuditEvent(event.getPullRequest(), PullRequestEventListener.getAction((PullRequestCommentEvent)event), (List<ChangedValue>)ImmutableList.of((Object)changedValue)));
    }

    @EventListener
    public void onPullRequestCommentEdited(PullRequestCommentEditedEvent event) {
        ImmutableList changedValues = ImmutableList.of((Object)ChangedValue.fromI18nKeys((String)ATTR_TEXT).from(PullRequestEventListener.truncateComment(event.getPreviousText())).to(PullRequestEventListener.truncateComment(event.getComment().getText())).build(), (Object)ChangedValue.fromI18nKeys((String)KEY_SEVERITY).from(event.getPreviousSeverity().name()).to(event.getComment().getSeverity().name()).build(), (Object)ChangedValue.fromI18nKeys((String)KEY_STATE).from(event.getPreviousState().name()).to(event.getComment().getState().name()).build());
        this.auditService.audit(PullRequestEventListener.pullRequestCommentAuditEvent(event.getPullRequest(), PullRequestEventListener.getAction((PullRequestCommentEvent)event), (List<ChangedValue>)changedValues));
    }

    @EventListener
    public void onPullRequestCommentReplied(PullRequestCommentRepliedEvent event) {
        ImmutableList changedValues = ImmutableList.of((Object)ChangedValue.fromI18nKeys((String)ATTR_TEXT).to(PullRequestEventListener.truncateComment(event.getComment().getText())).build(), (Object)ChangedValue.fromI18nKeys((String)KEY_SEVERITY).to(event.getComment().getSeverity().name()).build());
        this.auditService.audit(PullRequestEventListener.pullRequestCommentAuditEvent(event.getPullRequest(), PullRequestEventListener.getAction((PullRequestCommentEvent)event), (List<ChangedValue>)changedValues));
    }

    @EventListener
    public void onPullRequestDeclined(PullRequestDeclinedEvent event) {
        AuditEvent.Builder builder = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_PULL_REQUEST_DECLINED);
        this.addDraftToEventBuilder(event.getPullRequest().isDraft(), builder);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onPullRequestDeleted(PullRequestDeletedEvent event) {
        AuditEvent.Builder builder = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_PULL_REQUEST_DELETED);
        this.addDraftToEventBuilder(event.getPullRequest().isDraft(), builder);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onPullRequestMergeConfigBulkDeleted(PullRequestMergeConfigBulkDeletedEvent event) {
        AuditEvent auditEvent = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)"bitbucket.service.pullrequest.audit.action.bulkrepositorypullrequestmergeconfigdeleted").build()).affectedObject(AuditUtils.auditResourceForProject((Project)event.getProject())).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SCM, (String)event.getScmId()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MERGE_CONFIGS_DELETED, (String)String.valueOf(event.getMergeConfigsDeleted())).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onPullRequestMergeConfigDeleted(PullRequestMergeConfigDeletedEvent event) {
        this.auditService.audit(PullRequestEventListener.builderForMergeConfigEvent(event).build());
    }

    @EventListener
    public void onPullRequestMergeConfigUpdated(PullRequestMergeConfigUpdatedEvent event) {
        this.auditService.audit(PullRequestEventListener.builderForMergeConfigEvent(event).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_COMMIT_SUMMARIES).from(Integer.toString(event.getOldCommitSummaries())).to(Integer.toString(event.getCommitSummaries())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_DEFAULT_STRATEGY_ID).from(event.getOldDefaultStrategyId()).to(event.getDefaultStrategyId()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_ENABLED_STRATEGY_IDS).from(event.getOldEnabledStrategyIds().stream().sorted().collect(Collectors.joining(", "))).to(event.getEnabledStrategyIds().stream().sorted().collect(Collectors.joining(", "))).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_CONFIGURATION_LEVEL).from(event.getOldType().toString()).to(event.getType().toString()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_COMMIT_TEMPLATE_ENABLED).from(PullRequestEventListener.getCommitMessageTemplateEnabled(event.getOldPullRequestCommitMessageTemplate())).to(PullRequestEventListener.getCommitMessageTemplateEnabled(event.getPullRequestCommitMessageTemplate())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_COMMIT_TEMPLATE_TITLE).from(PullRequestEventListener.getCommitMessageTemplateTitle(event.getOldPullRequestCommitMessageTemplate())).to(PullRequestEventListener.getCommitMessageTemplateTitle(event.getPullRequestCommitMessageTemplate())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_COMMIT_TEMPLATE_BODY).from(PullRequestEventListener.getCommitMessageTemplateBody(event.getOldPullRequestCommitMessageTemplate())).to(PullRequestEventListener.getCommitMessageTemplateBody(event.getPullRequestCommitMessageTemplate())).build()).build());
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) {
        String message;
        AuditEvent.Builder builder = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_PULL_REQUEST_MERGED);
        MinimalCommit commit = event.getCommit();
        if (commit != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MERGE_COMMIT, (String)commit.getDisplayId()).build());
            ApplicationUser user = event.getUser();
            if (event.isAutoMerge() && user != null) {
                builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_AUTO_MERGED_BY, (String)user.getName()).build());
            }
        }
        if ((message = event.getMessage()) != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MESSAGE, (String)StringUtils.abbreviate((String)message, (int)256)).build());
        }
        this.addDraftToEventBuilder(event.getPullRequest().isDraft(), builder);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onPullRequestOpenRequested(PullRequestOpenRequestedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        Repository repository = pullRequest.getToRef().getRepository();
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.pullrequests", (String)ACTION_PULL_REQUEST_OPEN_REQUESTED).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repository));
        this.addDraftToEventBuilder(event.getPullRequest().isDraft(), builder);
        this.auditService.audit(PullRequestEventListener.addAttributesForRefs(pullRequest, builder).build());
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) {
        AuditEvent.Builder builder = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_PULL_REQUEST_OPENED);
        this.addDraftToEventBuilder(event.getPullRequest().isDraft(), builder);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onPullRequestParticipantStatusUpdated(PullRequestParticipantStatusUpdatedEvent event) {
        String actionI18nKey = null;
        switch (event.getAction()) {
            case APPROVED: {
                actionI18nKey = ACTION_PULL_REQUEST_PARTICIPANT_APPROVED;
                break;
            }
            case REVIEWED: {
                actionI18nKey = ACTION_PULL_REQUEST_PARTICIPANT_REVIEWED;
                break;
            }
            case UNAPPROVED: {
                actionI18nKey = ACTION_PULL_REQUEST_PARTICIPANT_UNAPPROVED;
            }
        }
        if (actionI18nKey != null) {
            AuditEvent auditEvent = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, actionI18nKey).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PARTICIPANT_STATUS).from(event.getPreviousStatus().name()).to(event.getParticipant().getStatus().name()).build()).build();
            this.auditService.audit(auditEvent);
        }
    }

    @EventListener
    public void onPullRequestParticipantsUpdated(PullRequestParticipantsUpdatedEvent event) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PullRequestEventListener.addPullRequestParticipantChangedDetails((ImmutableMap.Builder<String, Object>)builder, event.getAddedParticipants(), event.getRemovedParticipants());
        AuditEvent auditEvent = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_PULL_REQUEST_PARTICIPANTS_UPDATED).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PARTICIPANTS).from((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{event.getRemovedParticipants().stream().map(Principal::getName).collect(Collectors.joining(", "))})).to((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{event.getAddedParticipants().stream().map(Principal::getName).collect(Collectors.joining(", "))})).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onPullRequestRebased(GitPullRequestRebasedEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.pullrequests", (String)ACTION_PULL_REQUEST_REBASED).build();
        RefChange refChange = event.getRefChange();
        ChangedValue changedValue = ChangedValue.fromI18nKeys((String)KEY_COMMIT).from(refChange.getFromHash()).to(refChange.getToHash()).build();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).changedValue(changedValue).affectedObjects(AuditUtils.auditResourcesForProjectRepositoryPullRequest((PullRequest)event.getPullRequest())).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onPullRequestReopened(PullRequestReopenedEvent event) {
        AuditEvent.Builder builder = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_PULL_REQUEST_REOPENED);
        this.addDraftToEventBuilder(event.getPullRequest().isDraft(), builder);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onPullRequestReviewersUpdated(PullRequestReviewersUpdatedEvent event) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PullRequestEventListener.addPullRequestParticipantChangedDetails((ImmutableMap.Builder<String, Object>)builder, event.getAddedReviewers(), event.getRemovedReviewers());
        AuditEvent auditEvent = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_PULL_REQUEST_REVIEWERS_UPDATED).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_REVIEWERS).from((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{event.getRemovedReviewers().stream().map(Principal::getName).collect(Collectors.joining(", "))})).to((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{event.getAddedReviewers().stream().map(Principal::getName).collect(Collectors.joining(", "))})).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onPullRequestUpdated(@Nonnull PullRequestUpdatedEvent event) {
        if (this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS) && event.isPreviousDraft() != event.getPullRequest().isDraft()) {
            AuditEvent.Builder builder = PullRequestEventListener.toMinimalAuditEventBuilder((PullRequestEvent)event, ACTION_PULL_REQUEST_DRAFT_UPDATED).changedValue(ChangedValue.fromI18nKeys((String)ATTR_DRAFT).from(String.valueOf(event.isPreviousDraft())).to(String.valueOf(event.getPullRequest().isDraft())).build());
            this.auditService.audit(builder.build());
        }
    }

    @VisibleForTesting
    static String truncateComment(String comment) {
        return StringUtils.truncate((String)comment, (int)1800);
    }

    private static AuditEvent.Builder addAttributesForRefs(PullRequest pullRequest, AuditEvent.Builder builder) {
        PullRequestRef fromRef = pullRequest.getFromRef();
        PullRequestRef toRef = pullRequest.getToRef();
        return builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_FROM_REF, (String)(pullRequest.isCrossRepository() ? PullRequestEventListener.toFullyQualifiedRefId(fromRef) : fromRef.getDisplayId())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TO_REF, (String)(pullRequest.isCrossRepository() ? PullRequestEventListener.toFullyQualifiedRefId(toRef) : toRef.getDisplayId())).build());
    }

    private static void addPullRequestParticipantChangedDetails(ImmutableMap.Builder<String, Object> builder, Set<ApplicationUser> added, Set<ApplicationUser> removed) {
        if (!added.isEmpty()) {
            builder.put((Object)"added", PullRequestEventListener.toUserNames(added));
        }
        if (!removed.isEmpty()) {
            builder.put((Object)"removed", PullRequestEventListener.toUserNames(removed));
        }
    }

    private static AuditEvent.Builder builderForMergeConfigEvent(PullRequestMergeConfigEvent event) {
        String category;
        CoverageArea area;
        ImmutableList affectedObjects;
        String actionKey;
        String actionKeyFormat;
        String string = actionKeyFormat = event instanceof PullRequestMergeConfigDeletedEvent ? "bitbucket.service.pullrequest.audit.action.%spullrequestmergeconfigdeleted" : "bitbucket.service.pullrequest.audit.action.%spullrequestmergeconfigupdated";
        if (event.getRepository() != null) {
            actionKey = String.format(actionKeyFormat, "repository");
            affectedObjects = AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository());
            area = CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION;
            category = "bitbucket.service.audit.category.repositories";
        } else if (event.getProject() != null) {
            actionKey = String.format(actionKeyFormat, "project");
            affectedObjects = ImmutableList.of((Object)AuditUtils.auditResourceForProject((Project)event.getProject()));
            area = CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION;
            category = "bitbucket.service.audit.category.projects";
        } else {
            actionKey = String.format(actionKeyFormat, "scm");
            affectedObjects = Collections.emptyList();
            area = CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION;
            category = "bitbucket.service.audit.category.system";
        }
        return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)area, (CoverageLevel)CoverageLevel.ADVANCED, (String)category, (String)actionKey).build()).affectedObjects((List)affectedObjects).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SCM, (String)event.getScmId()).build());
    }

    private static String getAction(PullRequestCommentEvent event) {
        if (event.getComment().getSeverity() == CommentSeverity.BLOCKER) {
            return PullRequestEventListener.getTaskAction(event);
        }
        return PullRequestEventListener.getCommentAction(event);
    }

    private static String getCommentAction(PullRequestCommentEvent event) {
        switch (event.getCommentAction()) {
            case ADDED: {
                return ACTION_COMMENT_ADDED;
            }
            case DELETED: {
                return ACTION_COMMENT_DELETED;
            }
            case EDITED: {
                return ACTION_COMMENT_EDITED;
            }
            case REPLIED: {
                return ACTION_COMMENT_REPLIED;
            }
        }
        return event.getClass().getSimpleName();
    }

    private static String getCommitMessageTemplateBody(PullRequestCommitMessageTemplate template) {
        return template == null ? null : template.getBody();
    }

    private static String getCommitMessageTemplateEnabled(PullRequestCommitMessageTemplate template) {
        return Boolean.toString(template != null);
    }

    private static String getCommitMessageTemplateTitle(PullRequestCommitMessageTemplate template) {
        return template == null ? null : template.getTitle();
    }

    private static String getTaskAction(PullRequestCommentEvent event) {
        switch (event.getCommentAction()) {
            case ADDED: 
            case REPLIED: {
                return ACTION_TASK_ADDED;
            }
            case DELETED: {
                return ACTION_TASK_DELETED;
            }
            case EDITED: {
                return ACTION_TASK_EDITED;
            }
        }
        return event.getClass().getSimpleName();
    }

    private static AuditEvent pullRequestCommentAuditEvent(PullRequest pullRequest, String action, List<ChangedValue> changedValues) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.pullrequests", (String)action).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)type).affectedObjects(AuditUtils.auditResourcesForProjectRepositoryPullRequest((PullRequest)pullRequest));
        changedValues.forEach(arg_0 -> ((AuditEvent.Builder)builder).addChangedValueIfDifferent(arg_0));
        changedValues.stream().filter(changedValue -> changedValue.getI18nKey().equals(ATTR_TEXT)).findAny().filter(changedValue -> Objects.equals(changedValue.getFrom(), changedValue.getTo())).ifPresent(changedValue -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TEXT, (String)changedValue.getTo()).build()));
        return builder.build();
    }

    private static String toFullyQualifiedRefId(PullRequestRef ref) {
        return String.format("%s:%s", AuditUtils.toProjectAndRepositoryString((Repository)ref.getRepository()), ref.getDisplayId());
    }

    private static AuditEvent.Builder toMinimalAuditEventBuilder(PullRequestEvent pullRequestEvent, String actionI18nKey) {
        PullRequest pullRequest = pullRequestEvent.getPullRequest();
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.pullrequests", (String)actionI18nKey).build();
        return PullRequestEventListener.addAttributesForRefs(pullRequest, AuditEvent.builder((AuditType)auditType)).affectedObjects(AuditUtils.auditResourcesForProjectRepositoryPullRequest((PullRequest)pullRequest));
    }

    private static List<String> toUserNames(Collection<ApplicationUser> users) {
        return PullRequestEventListener.toUserNames(users.stream());
    }

    private static List<String> toUserNames(Stream<ApplicationUser> users) {
        return (List)users.map(Principal::getName).collect(MoreCollectors.toImmutableList());
    }

    private void addDraftToEventBuilder(boolean draft, AuditEvent.Builder builder) {
        if (this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_DRAFTS)) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DRAFT, (String)String.valueOf(draft)).build());
        }
    }

    private void auditMinimalPullRequestEvent(PullRequestEvent pullRequestEvent, String actionI18nKey) {
        this.auditService.audit(PullRequestEventListener.toMinimalAuditEventBuilder(pullRequestEvent, actionI18nKey).build());
    }
}

