/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.audit.ScopedAuditEventBuilderFactory;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateCreatedEvent;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateDeletedEvent;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateEvent;
import com.atlassian.stash.internal.pull.template.PullRequestTemplateUpdatedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestTemplateEventListener {
    @VisibleForTesting
    static final String ATTR_PULL_REQUEST_TEMPLATE_DESCRIPTION = "bitbucket.service.pullrequesttemplate.audit.attribute.description";
    @VisibleForTesting
    static final String ATTR_PULL_REQUEST_TEMPLATE_ENABLED = "bitbucket.service.pullrequesttemplate.audit.attribute.enabled";
    private static final String AUDIT_ACTION_KEY_PREFIX = "bitbucket.service.pullrequesttemplate.audit.action.";
    @VisibleForTesting
    static final Map<Class<?>, String> I18N_ACTION_KEYS = ImmutableMap.builder().put(PullRequestTemplateCreatedEvent.class, (Object)"bitbucket.service.pullrequesttemplate.audit.action.templatecreated").put(PullRequestTemplateDeletedEvent.class, (Object)"bitbucket.service.pullrequesttemplate.audit.action.templatedeleted").put(PullRequestTemplateUpdatedEvent.class, (Object)"bitbucket.service.pullrequesttemplate.audit.action.templateupdated").build();
    private static final int MAX_DESCRIPTION_CHARACTERS_LENGTH = 1800;
    private final ScopedAuditEventBuilderFactory auditEventBuilderFactory;
    private final AuditService auditService;

    @Autowired
    public PullRequestTemplateEventListener(ScopedAuditEventBuilderFactory auditEventBuilderFactory, AuditService auditService) {
        this.auditEventBuilderFactory = auditEventBuilderFactory;
        this.auditService = auditService;
    }

    @EventListener
    public void onPullRequestTemplateCreated(PullRequestTemplateCreatedEvent event) {
        AuditEvent.Builder builder = this.getAuditEventBuilder(event).extraAttribute(PullRequestTemplateEventListener.toAttribute(ATTR_PULL_REQUEST_TEMPLATE_ENABLED, Boolean.toString(event.isEnabled()))).extraAttribute(PullRequestTemplateEventListener.toAttribute(ATTR_PULL_REQUEST_TEMPLATE_DESCRIPTION, PullRequestTemplateEventListener.abbreviateDescription(event.getDescription())));
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onPullRequestTemplateDeleted(PullRequestTemplateDeletedEvent event) {
        this.auditService.audit(this.getAuditEventBuilder(event).build());
    }

    @EventListener
    public void onPullRequestTemplateUpdated(PullRequestTemplateUpdatedEvent event) {
        AuditEvent.Builder builder = this.getAuditEventBuilder(event).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_PULL_REQUEST_TEMPLATE_ENABLED).from(Boolean.toString(event.getOldTemplate().isEnabled())).to(Boolean.toString(event.getNewTemplate().isEnabled())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_PULL_REQUEST_TEMPLATE_DESCRIPTION).from(PullRequestTemplateEventListener.abbreviateDescription(event.getOldTemplate().getDescription())).to(PullRequestTemplateEventListener.abbreviateDescription(event.getNewTemplate().getDescription())).build());
        this.auditService.audit(builder.build());
    }

    private static String abbreviateDescription(String description) {
        return StringUtils.abbreviate((String)description, (int)1800);
    }

    private AuditEvent.Builder getAuditEventBuilder(PullRequestTemplateEvent event) {
        Class<?> eventClass = ((Object)((Object)event)).getClass();
        String actionKey = I18N_ACTION_KEYS.getOrDefault(eventClass, eventClass.getSimpleName());
        return this.auditEventBuilderFactory.createScopedAdminAuditEventBuilder(actionKey, CoverageLevel.ADVANCED, event.getScope());
    }

    private static AuditAttribute toAttribute(String i18nKey, String value) {
        return AuditAttribute.fromI18nKeys((String)i18nKey, (String)value).build();
    }
}

