/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.hook.RepositoryHookDeletedEvent;
import com.atlassian.bitbucket.event.hook.RepositoryHookDisabledEvent;
import com.atlassian.bitbucket.event.hook.RepositoryHookEnabledEvent;
import com.atlassian.bitbucket.event.hook.RepositoryHookEvent;
import com.atlassian.bitbucket.event.hook.RepositoryHookSettingsChangedEvent;
import com.atlassian.bitbucket.event.repository.AbstractRepositoryModificationEvent;
import com.atlassian.bitbucket.event.repository.PullRequestFilterEvent;
import com.atlassian.bitbucket.event.repository.RepositoryAccessedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCloneEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreationFailedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryCreationRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDefaultBranchModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkFailedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryImportedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModificationRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryOtherReadEvent;
import com.atlassian.bitbucket.event.repository.RepositoryOtherWriteEvent;
import com.atlassian.bitbucket.event.repository.RepositoryPullEvent;
import com.atlassian.bitbucket.event.repository.RepositoryPushEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.audit.AuditRefChangeUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryEventListener {
    private static final String AUDIT_ACTION_KEY_PREFIX = "bitbucket.service.repository.audit.action.";
    private static final String AUDIT_CHANGED_VALUE_KEY_PREFIX = "bitbucket.service.repository.audit.changedvalue.";
    private static final String AUDIT_ATTRIBUTE_KEY_PREFIX = "bitbucket.service.repository.audit.attribute.";
    @VisibleForTesting
    static final String ACTION_PULL_REQUEST_FILTER = "bitbucket.service.repository.audit.action.pullrequestfilter";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_ACCESSED = "bitbucket.service.repository.audit.action.repositoryaccessed";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_CLONE = "bitbucket.service.repository.audit.action.repositoryclone";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_CREATED = "bitbucket.service.repository.audit.action.repositorycreated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_CREATION_FAILED = "bitbucket.service.repository.audit.action.repositorycreationfailed";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_CREATION_REQUESTED = "bitbucket.service.repository.audit.action.repositorycreationrequested";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_DEFAULT_BRANCH_MODIFIED = "bitbucket.service.repository.audit.action.repositorydefaultbranchmodified";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_DELETED = "bitbucket.service.repository.audit.action.repositorydeleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_DELETION_REQUESTED = "bitbucket.service.repository.audit.action.repositorydeletionrequested";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_FORKED = "bitbucket.service.repository.audit.action.repositoryforked";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_FORK_FAILED = "bitbucket.service.repository.audit.action.repositoryforkfailed";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_HOOK_DELETED = "bitbucket.service.repository.audit.action.repositoryhookdeleted.";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_HOOK_DISABLED = "bitbucket.service.repository.audit.action.repositoryhookdisabled.";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_HOOK_ENABLED = "bitbucket.service.repository.audit.action.repositoryhookenabled.";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_HOOK_SETTINGS_CHANGED = "bitbucket.service.repository.audit.action.repositoryhooksettingschanged.";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_IMPORTED = "bitbucket.service.repository.audit.action.repositoryimported";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_MODIFICATION_REQUESTED = "bitbucket.service.repository.audit.action.repositorymodificationrequested";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_MODIFIED = "bitbucket.service.repository.audit.action.repositorymodified";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_OTHER_READ = "bitbucket.service.repository.audit.action.repositoryotherread";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_OTHER_WRITE = "bitbucket.service.repository.audit.action.repositoryotherwrite";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_PULL = "bitbucket.service.repository.audit.action.repositorypull";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_PUSH = "bitbucket.service.repository.audit.action.repositorypush";
    @VisibleForTesting
    static final String ATTR_AUTHOR = "bitbucket.service.repository.audit.attribute.pullrequestfilter.author";
    @VisibleForTesting
    static final String ATTR_BRANCH = "bitbucket.service.repository.audit.attribute.pullrequestfilter.branch";
    @VisibleForTesting
    static final String ATTR_FILTER = "bitbucket.service.repository.audit.attribute.pullrequestfilter.filter";
    @VisibleForTesting
    static final String ATTR_HOOK_KEY = "bitbucket.service.repository.audit.attribute.repositoryhook.repositoryhookkey";
    @VisibleForTesting
    static final String ATTR_ORIGIN = "bitbucket.service.repository.audit.attribute.repositorycreated.origin";
    @VisibleForTesting
    static final String ATTR_TARGET_REPO = "bitbucket.service.repository.audit.attribute.repositorycreated.targetrepo";
    @VisibleForTesting
    static final String ATTR_REF_CHANGES = "bitbucket.service.repository.audit.attribute.repositorypush.refchanges";
    @VisibleForTesting
    static final String ATTR_REVIEWER = "bitbucket.service.repository.audit.attribute.pullrequestfilter.reviewer";
    @VisibleForTesting
    static final String ATTR_STATE = "bitbucket.service.repository.audit.attribute.pullrequestfilter.state";
    @VisibleForTesting
    static final String KEY_BRANCH = "bitbucket.service.repository.audit.changedvalue.repositorydefaultbranchmodified.branch";
    @VisibleForTesting
    static final String KEY_ARCHIVED = "bitbucket.service.repository.audit.changedvalue.repositorymodification.archived";
    @VisibleForTesting
    static final String KEY_FORKABLE = "bitbucket.service.repository.audit.changedvalue.repositorymodification.forkable";
    @VisibleForTesting
    static final String KEY_HOOK_SETTINGS = "bitbucket.service.repository.audit.changedvalue.repositoryhooksettingschanged.settings";
    @VisibleForTesting
    static final String KEY_PUBLIC = "bitbucket.service.repository.audit.changedvalue.repositorymodification.public";
    @VisibleForTesting
    static final String KEY_PROJECT = "bitbucket.service.repository.audit.changedvalue.repositorymodification.project";
    @VisibleForTesting
    static final String KEY_REPO_NAME = "bitbucket.service.repository.audit.changedvalue.repositorymodification.name";
    private static final Map<Class<?>, String> ACTION_KEY_MAPPING = ImmutableMap.builder().put(RepositoryCreatedEvent.class, (Object)"bitbucket.service.repository.audit.action.repositorycreated").put(RepositoryCreationFailedEvent.class, (Object)"bitbucket.service.repository.audit.action.repositorycreationfailed").put(RepositoryCreationRequestedEvent.class, (Object)"bitbucket.service.repository.audit.action.repositorycreationrequested").put(RepositoryForkedEvent.class, (Object)"bitbucket.service.repository.audit.action.repositoryforked").put(RepositoryForkFailedEvent.class, (Object)"bitbucket.service.repository.audit.action.repositoryforkfailed").put(RepositoryHookDeletedEvent.class, (Object)"bitbucket.service.repository.audit.action.repositoryhookdeleted.").put(RepositoryHookDisabledEvent.class, (Object)"bitbucket.service.repository.audit.action.repositoryhookdisabled.").put(RepositoryHookEnabledEvent.class, (Object)"bitbucket.service.repository.audit.action.repositoryhookenabled.").put(RepositoryHookSettingsChangedEvent.class, (Object)"bitbucket.service.repository.audit.action.repositoryhooksettingschanged.").put(RepositoryImportedEvent.class, (Object)"bitbucket.service.repository.audit.action.repositoryimported").build();
    private static final String NO_USER_INPUT = "(NONE)";
    private static final String PR_STATE_ALL = "ALL";
    private final AuditService auditService;

    @Autowired
    public RepositoryEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onPullRequestFilterEvent(PullRequestFilterEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.pullrequests", (String)ACTION_PULL_REQUEST_FILTER).build();
        AuditEvent.Builder builder = new AuditEvent.Builder(type).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)event.getRepository()));
        builder.extraAttributes((Collection)ImmutableList.of((Object)AuditAttribute.fromI18nKeys((String)ATTR_AUTHOR, (String)event.getAuthor().orElse(NO_USER_INPUT)).build(), (Object)AuditAttribute.fromI18nKeys((String)ATTR_REVIEWER, (String)event.getReviewer().orElse(NO_USER_INPUT)).build(), (Object)AuditAttribute.fromI18nKeys((String)ATTR_FILTER, (String)event.getFilterText().orElse(NO_USER_INPUT)).build(), (Object)AuditAttribute.fromI18nKeys((String)ATTR_BRANCH, (String)event.getBranch().orElse(NO_USER_INPUT)).build(), (Object)AuditAttribute.fromI18nKeys((String)ATTR_STATE, (String)event.getState().map(Enum::name).orElse(PR_STATE_ALL)).build()));
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onRepositoryAccessed(RepositoryAccessedEvent event) {
        AuditEvent.Builder builder = RepositoryEventListener.toAuditEventBuilder((RepositoryEvent)event, AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)ACTION_REPOSITORY_ACCESSED).build());
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onRepositoryCreated(RepositoryCreatedEvent event) {
        String actionI18nKey = RepositoryEventListener.getActionKey(event.getClass(), true);
        Repository repository = event.getRepository();
        ArrayList<AuditAttribute> hierarchyAttributes = new ArrayList<AuditAttribute>();
        Repository origin = repository.getOrigin();
        if (origin != null) {
            hierarchyAttributes.add(AuditAttribute.fromI18nKeys((String)ATTR_ORIGIN, (String)AuditUtils.toProjectAndRepositoryString((Repository)origin)).build());
            hierarchyAttributes.add(AuditAttribute.fromI18nKeys((String)ATTR_TARGET_REPO, (String)AuditUtils.toProjectAndRepositoryString((Repository)repository)).build());
        }
        AuditEvent.Builder builder = RepositoryEventListener.toConfigAuditEventBuilder((RepositoryEvent)event, actionI18nKey).appendExtraAttributes(hierarchyAttributes);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onRepositoryCreationFailed(RepositoryCreationFailedEvent event) {
        String actionI18nKey = RepositoryEventListener.getActionKey(event.getClass(), true);
        this.auditService.audit(RepositoryEventListener.toConfigAuditEventBuilder((RepositoryEvent)event, actionI18nKey).build());
    }

    @EventListener
    public void onRepositoryCreationRequested(RepositoryCreationRequestedEvent event) {
        String actionI18nKey = RepositoryEventListener.getActionKey(event.getClass(), true);
        this.auditService.audit(RepositoryEventListener.toConfigAuditEventBuilder((RepositoryEvent)event, actionI18nKey).build());
    }

    @EventListener
    public void onRepositoryDefaultBranchModified(RepositoryDefaultBranchModifiedEvent event) {
        AuditEvent.Builder builder = RepositoryEventListener.toConfigAuditEventBuilder((RepositoryEvent)event, ACTION_REPOSITORY_DEFAULT_BRANCH_MODIFIED).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_BRANCH).from(event.getOldValue()).to(event.getNewValue()).build());
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.auditService.audit(RepositoryEventListener.toConfigAuditEventBuilder((RepositoryEvent)event, ACTION_REPOSITORY_DELETED).build());
    }

    @EventListener
    public void onRepositoryDeletionRequested(RepositoryDeletionRequestedEvent event) {
        this.auditService.audit(RepositoryEventListener.toConfigAuditEventBuilder((RepositoryEvent)event, ACTION_REPOSITORY_DELETION_REQUESTED).build());
    }

    @EventListener
    public void onRepositoryHook(RepositoryHookEvent event) {
        final AuditEvent.Builder builder = AuditEvent.fromI18nKeys((String)"bitbucket.service.audit.category.projects", (String)RepositoryEventListener.getActionKey(event), (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_HOOK_KEY, (String)event.getRepositoryHookKey()).build());
        Optional.ofNullable((AuditEvent.Builder)event.getScope().accept((ScopeVisitor)new ScopeVisitor<AuditEvent.Builder>(){

            public AuditEvent.Builder visit(@Nonnull ProjectScope scope) {
                return builder.affectedObject(AuditUtils.auditResourceForProject((Project)scope.getProject()));
            }

            public AuditEvent.Builder visit(@Nonnull RepositoryScope scope) {
                return builder.categoryI18nKey("bitbucket.service.audit.category.repositories").appendAffectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository()));
            }
        })).ifPresent(b -> {
            if (event instanceof RepositoryHookSettingsChangedEvent) {
                RepositoryHookSettingsChangedEvent settingsChangedEvent = (RepositoryHookSettingsChangedEvent)event;
                builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_HOOK_SETTINGS).from(RepositoryEventListener.toChangedValue(settingsChangedEvent.getOldSettings())).to(RepositoryEventListener.toChangedValue(settingsChangedEvent.getSettings())).build());
            }
            this.auditService.audit(b.build());
        });
    }

    @EventListener
    public void onRepositoryModificationRequested(RepositoryModificationRequestedEvent event) {
        this.auditRepositoryModificationEvent((AbstractRepositoryModificationEvent)event, ACTION_REPOSITORY_MODIFICATION_REQUESTED);
    }

    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent event) {
        this.auditRepositoryModificationEvent((AbstractRepositoryModificationEvent)event, ACTION_REPOSITORY_MODIFIED);
    }

    @EventListener
    public void onRepositoryOtherRead(RepositoryOtherReadEvent event) {
        AuditEvent.Builder builder = RepositoryEventListener.toEndUserActivityAuditEventBuilder((RepositoryEvent)event, ACTION_REPOSITORY_OTHER_READ);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onRepositoryOtherWrite(RepositoryOtherWriteEvent event) {
        AuditEvent.Builder builder = RepositoryEventListener.toEndUserActivityAuditEventBuilder((RepositoryEvent)event, ACTION_REPOSITORY_OTHER_WRITE);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onRepositoryPull(RepositoryPullEvent event) {
        String actionI18nKey = event instanceof RepositoryCloneEvent ? ACTION_REPOSITORY_CLONE : ACTION_REPOSITORY_PULL;
        this.auditService.audit(RepositoryEventListener.toEndUserActivityAuditEventBuilder((RepositoryEvent)event, actionI18nKey).build());
    }

    @EventListener
    public void onRepositoryPush(RepositoryPushEvent event) {
        String refChangesJson = AuditUtils.toJson(AuditRefChangeUtils.toMaps(event.getRefChanges()));
        AuditEvent.Builder builder = RepositoryEventListener.toEndUserActivityAuditEventBuilder((RepositoryEvent)event, ACTION_REPOSITORY_PUSH).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REF_CHANGES, (String)refChangesJson).build());
        this.auditService.audit(builder.build());
    }

    private static String getActionKey(RepositoryHookEvent event) {
        final String actionKeyPrefix = RepositoryEventListener.getActionKey(event.getClass(), false);
        final String className = event.getClass().getSimpleName();
        return (String)event.getScope().accept((ScopeVisitor)new ScopeVisitor<String>(){

            public String visit(@Nonnull GlobalScope scope) {
                return className;
            }

            public String visit(@Nonnull ProjectScope scope) {
                return actionKeyPrefix == null ? className : actionKeyPrefix + "project";
            }

            public String visit(@Nonnull RepositoryScope scope) {
                return actionKeyPrefix == null ? className : actionKeyPrefix + "repository";
            }
        });
    }

    private static String getActionKey(Class<?> eventClass, boolean withDefault) {
        Class<?> key = eventClass;
        do {
            String mapping;
            if ((mapping = ACTION_KEY_MAPPING.get(key)) == null) continue;
            return mapping;
        } while (!Object.class.equals(key = key.getSuperclass()));
        return withDefault ? eventClass.getSimpleName() : null;
    }

    private static AuditEvent.Builder toAuditEventBuilder(RepositoryEvent event, AuditType auditType) {
        Repository repository = event.getRepository();
        return AuditEvent.builder((AuditType)auditType).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repository));
    }

    private static AuditEvent.Builder toConfigAuditEventBuilder(RepositoryEvent event, String actionI18nKey) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.repositories", (String)actionI18nKey).build();
        return RepositoryEventListener.toAuditEventBuilder(event, auditType);
    }

    private static AuditEvent.Builder toEndUserActivityAuditEventBuilder(RepositoryEvent event, String actionI18nKey) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.repositories", (String)actionI18nKey).build();
        return RepositoryEventListener.toAuditEventBuilder(event, auditType);
    }

    private static String toChangedValue(Settings settings) {
        return Optional.ofNullable(settings).filter(s -> !s.asMap().isEmpty()).map(s -> AuditUtils.toJson((Object)s.asMap())).orElse(null);
    }

    private void auditRepositoryModificationEvent(AbstractRepositoryModificationEvent event, String actionI18nKey) {
        Repository beforeChange = event.getOldValue();
        Repository afterChange = event.getNewValue();
        AuditEvent.Builder builder = RepositoryEventListener.toConfigAuditEventBuilder((RepositoryEvent)event, actionI18nKey).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_ARCHIVED).from(String.valueOf(beforeChange.isArchived())).to(String.valueOf(afterChange.isArchived())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_REPO_NAME).from(beforeChange.getName()).to(afterChange.getName()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_FORKABLE).from(String.valueOf(beforeChange.isForkable())).to(String.valueOf(afterChange.isForkable())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PUBLIC).from(String.valueOf(beforeChange.isPublic())).to(String.valueOf(afterChange.isPublic())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PROJECT).from(String.valueOf(beforeChange.getProject().getKey())).to(String.valueOf(afterChange.getProject().getKey())).build());
        this.auditService.audit(builder.build());
    }
}

