/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.audit.ScopedAuditEventBuilderFactory;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupCreatedEvent;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupDeletedEvent;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupEvent;
import com.atlassian.stash.internal.pull.reviewer.ReviewerGroupUpdatedEvent;
import java.security.Principal;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReviewerGroupEventListener {
    private static final String AUDIT_ACTION_CREATED = "bitbucket.service.reviewergroup.audit.action.created";
    private static final String AUDIT_ACTION_DELETED = "bitbucket.service.reviewergroup.audit.action.deleted";
    private static final String AUDIT_ACTION_UPDATED = "bitbucket.service.reviewergroup.audit.action.updated";
    private static final String AUDIT_ATTRIBUTE_DESCRIPTION = "bitbucket.service.reviewergroup.audit.attribute.description";
    private static final String AUDIT_ATTRIBUTE_NAME = "bitbucket.service.reviewergroup.audit.attribute.name";
    private static final String AUDIT_ATTRIBUTE_USERS = "bitbucket.service.reviewergroup.audit.attribute.users";
    private final ScopedAuditEventBuilderFactory auditEventBuilder;
    private final AuditService auditService;

    @Autowired
    public ReviewerGroupEventListener(ScopedAuditEventBuilderFactory auditEventBuilder, AuditService auditService) {
        this.auditEventBuilder = auditEventBuilder;
        this.auditService = auditService;
    }

    @EventListener
    public void onReviewerGroupCreated(ReviewerGroupCreatedEvent event) {
        AuditEvent.Builder builder = this.createBaseReviewerGroupAuditEvent(AUDIT_ACTION_CREATED, event).extraAttribute(AuditAttribute.fromI18nKeys((String)AUDIT_ATTRIBUTE_DESCRIPTION, (String)event.getReviewerGroup().getDescription()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)AUDIT_ATTRIBUTE_USERS, (String)ReviewerGroupEventListener.stringifyUsers(event.getReviewerGroup().getUsers())).build());
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onReviewerGroupDeleted(ReviewerGroupDeletedEvent event) {
        AuditEvent.Builder builder = this.createBaseReviewerGroupAuditEvent(AUDIT_ACTION_DELETED, event);
        this.auditService.audit(builder.build());
    }

    @EventListener
    public void onReviewerGroupUpdated(ReviewerGroupUpdatedEvent event) {
        AuditEvent.Builder builder = this.createBaseReviewerGroupAuditEvent(AUDIT_ACTION_UPDATED, event);
        ReviewerGroup currentGroup = event.getReviewerGroup();
        ReviewerGroup previousGroup = event.getPreviousReviewerGroup();
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)AUDIT_ATTRIBUTE_NAME).from(previousGroup.getName()).to(currentGroup.getName()).build());
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)AUDIT_ATTRIBUTE_DESCRIPTION).from(previousGroup.getDescription()).to(currentGroup.getDescription()).build());
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)AUDIT_ATTRIBUTE_USERS).from(ReviewerGroupEventListener.stringifyUsers(previousGroup.getUsers())).to(ReviewerGroupEventListener.stringifyUsers(currentGroup.getUsers())).build());
        this.auditService.audit(builder.build());
    }

    private AuditEvent.Builder createBaseReviewerGroupAuditEvent(String actionI18nKey, ReviewerGroupEvent event) {
        return this.auditEventBuilder.createScopedAdminAuditEventBuilder(actionI18nKey, CoverageLevel.ADVANCED, event.getScope()).extraAttribute(AuditAttribute.fromI18nKeys((String)AUDIT_ATTRIBUTE_NAME, (String)event.getReviewerGroup().getName()).build());
    }

    private static String stringifyUsers(Set<ApplicationUser> users) {
        return users.stream().map(Principal::getName).sorted().collect(Collectors.joining(", "));
    }
}

