/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScopedAuditEventBuilderFactory {
    public AuditEvent.Builder createScopedAdminAuditEventBuilder(String actionI18nKey, CoverageLevel coverageLevel, Scope scope) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)ScopedAuditEventBuilderFactory.getCoverageArea(scope), (CoverageLevel)coverageLevel, (String)ScopedAuditEventBuilderFactory.getAuditCategory(scope), (String)actionI18nKey).build();
        return AuditEvent.builder((AuditType)auditType).affectedObjects(ScopedAuditEventBuilderFactory.getAffectedObjects(scope));
    }

    private static List<AuditResource> getAffectedObjects(Scope scope) {
        return (List)scope.accept((ScopeVisitor)new ScopeVisitor<List<AuditResource>>(){

            public List<AuditResource> visit(@Nonnull GlobalScope globalScope) {
                return Collections.singletonList(AuditUtils.miscellaneousAuditResource((String)globalScope.toString()));
            }

            public List<AuditResource> visit(@Nonnull ProjectScope projectScope) {
                return Collections.singletonList(AuditUtils.auditResourceForProject((Project)projectScope.getProject()));
            }

            public List<AuditResource> visit(@Nonnull RepositoryScope repositoryScope) {
                return AuditUtils.auditResourcesForProjectAndRepository((Repository)repositoryScope.getRepository());
            }
        });
    }

    private static String getAuditCategory(Scope scope) {
        return (String)scope.accept((ScopeVisitor)new ScopeVisitor<String>(){

            public String visit(@Nonnull GlobalScope globalScope) {
                return "bitbucket.service.audit.category.system";
            }

            public String visit(@Nonnull ProjectScope projectScope) {
                return "bitbucket.service.audit.category.projects";
            }

            public String visit(@Nonnull RepositoryScope repositoryScope) {
                return "bitbucket.service.audit.category.repositories";
            }
        });
    }

    private static CoverageArea getCoverageArea(Scope scope) {
        return scope.getType() == ScopeType.GLOBAL ? CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION : CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION;
    }
}

