/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.policy.RepositoryArchivePolicyChangedEvent;
import com.atlassian.bitbucket.dmz.policy.RepositoryDeletePolicyChangedEvent;
import com.atlassian.bitbucket.event.backup.BackupCanceledEvent;
import com.atlassian.bitbucket.event.backup.BackupEvent;
import com.atlassian.bitbucket.event.backup.BackupFailedEvent;
import com.atlassian.bitbucket.event.backup.BackupStartedEvent;
import com.atlassian.bitbucket.event.backup.BackupSucceededEvent;
import com.atlassian.bitbucket.event.license.LicenseChangedEvent;
import com.atlassian.bitbucket.event.migration.MigrationCanceledEvent;
import com.atlassian.bitbucket.event.migration.MigrationEvent;
import com.atlassian.bitbucket.event.migration.MigrationFailedEvent;
import com.atlassian.bitbucket.event.migration.MigrationStartedEvent;
import com.atlassian.bitbucket.event.migration.MigrationSucceededEvent;
import com.atlassian.bitbucket.event.server.ApplicationConfigurationChangedEvent;
import com.atlassian.bitbucket.event.server.ApplicationSetupEvent;
import com.atlassian.bitbucket.event.server.BaseUrlChangedEvent;
import com.atlassian.bitbucket.event.server.DisplayNameChangedEvent;
import com.atlassian.bitbucket.event.server.HttpScmHostingChangedEvent;
import com.atlassian.bitbucket.event.server.MailHostConfigurationChangedEvent;
import com.atlassian.bitbucket.event.server.ServerEmailAddressChangedEvent;
import com.atlassian.bitbucket.event.server.ServerTimeZoneChangedEvent;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.log.LoggingSettingsChangedEvent;
import com.atlassian.stash.internal.server.ProfilingSettingsChangedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerEventListener {
    @VisibleForTesting
    static final String ACTION_APPLICATION_SETUP_EVENT = "bitbucket.service.applicationconfiguration.audit.action.applicationsetup";
    @VisibleForTesting
    static final String ACTION_BACKUP_CANCELLED_EVENT = "bitbucket.service.backup.audit.action.backupcancelled";
    @VisibleForTesting
    static final String ACTION_BACKUP_FAILED_EVENT = "bitbucket.service.backup.audit.action.backupfailed";
    @VisibleForTesting
    static final String ACTION_BACKUP_STARTED_EVENT = "bitbucket.service.backup.audit.action.backupstarted";
    @VisibleForTesting
    static final String ACTION_BACKUP_SUCCEEDED_EVENT = "bitbucket.service.backup.audit.action.backupsucceeded";
    @VisibleForTesting
    static final String ACTION_BASE_URL_EVENT = "bitbucket.service.applicationconfiguration.audit.action.baseurlchanged";
    @VisibleForTesting
    static final String ACTION_DISPLAY_NAME_EVENT = "bitbucket.service.applicationconfiguration.audit.action.displaynamechanged";
    @VisibleForTesting
    static final String ACTION_HTTP_SCM_EVENT = "bitbucket.service.applicationconfiguration.audit.action.httpscmchanged";
    @VisibleForTesting
    static final String ACTION_LICENSE_CHANGED = "bitbucket.service.license.audit.action.licensechanged";
    @VisibleForTesting
    static final String ACTION_LOGGING_DISABLED = "bitbucket.logging.audit.action.loggingsettingsdisabled";
    @VisibleForTesting
    static final String ACTION_LOGGING_ENABLED = "bitbucket.logging.audit.action.loggingsettingsenabled";
    @VisibleForTesting
    static final String ACTION_MAIL_HOST_CONFIGURATION_EVENT = "bitbucket.service.applicationconfiguration.audit.action.mailserverchanged";
    @VisibleForTesting
    static final String ACTION_MIGRATION_CANCELLED = "bitbucket.service.migration.audit.action.migrationcancelled";
    @VisibleForTesting
    static final String ACTION_MIGRATION_FAILED = "bitbucket.service.migration.audit.action.migrationfailed";
    @VisibleForTesting
    static final String ACTION_MIGRATION_STARTED = "bitbucket.service.migration.audit.action.migrationstarted";
    @VisibleForTesting
    static final String ACTION_MIGRATION_SUCCEEDED = "bitbucket.service.migration.audit.action.migrationsucceeded";
    @VisibleForTesting
    static final String ACTION_PROFILING_DISABLED = "bitbucket.profiling.audit.action.profilingsettingsdisabled";
    @VisibleForTesting
    static final String ACTION_PROFILING_ENABLED = "bitbucket.profiling.audit.action.profilingsettingsenabled";
    @VisibleForTesting
    static final String ACTION_REPO_ARCHIVE_CHANGED = "bitbucket.policies.audit.action.repositoryarchivepolicychanged";
    @VisibleForTesting
    static final String ACTION_REPO_DELETE_CHANGED = "bitbucket.policies.audit.action.repositorydeletepolicychanged";
    @VisibleForTesting
    static final String ACTION_SERVER_EMAIL_ADDRESS_EVENT = "bitbucket.service.applicationconfiguration.audit.action.serveremailaddresschanged";
    @VisibleForTesting
    static final String ACTION_SERVER_TIMEZONE_EVENT = "bitbucket.service.applicationconfiguration.audit.action.servertimezonechanged";
    @VisibleForTesting
    static final String ACTION_TICKET_REJECTED_EVENT = "bitbucket.service.ticket.audit.action.ticketrejected";
    @VisibleForTesting
    static final String ATTR_RESOURCE_NAME = "bitbucket.service.ticket.audit.attribute.ticketrejected.name";
    @VisibleForTesting
    static final String KEY_BASE_URL = "bitbucket.service.applicationconfiguration.audit.changedvalue.baseurlchanged.baseurl";
    @VisibleForTesting
    static final String KEY_EMAIL_ADDRESS = "bitbucket.service.applicationconfiguration.audit.changedvalue.serveremailaddresschanged.emailaddress";
    @VisibleForTesting
    static final String KEY_HOSTNAME = "bitbucket.service.applicationconfiguration.audit.changedvalue.mailserverchanged.hostname";
    @VisibleForTesting
    static final String KEY_HTTP_SCM_ENABLED = "bitbucket.service.applicationconfiguration.audit.changedvalue.httpscmchanged.accessenabled";
    @VisibleForTesting
    static final String KEY_POLICY = "bitbucket.service.applicationconfiguration.audit.changedvalue.policy";
    @VisibleForTesting
    static final String KEY_PORT = "bitbucket.service.applicationconfiguration.audit.changedvalue.mailserverchanged.port";
    @VisibleForTesting
    static final String KEY_PROTOCOL = "bitbucket.service.applicationconfiguration.audit.changedvalue.mailserverchanged.protocol";
    @VisibleForTesting
    static final String KEY_SERVER_NAME = "bitbucket.service.applicationconfiguration.audit.changedvalue.displaynamechanged.name";
    @VisibleForTesting
    static final String KEY_TIME_ZONE = "bitbucket.service.applicationconfiguration.audit.changedvalue.servertimezonechanged.timezone";
    @VisibleForTesting
    static final String KEY_USERNAME = "bitbucket.service.applicationconfiguration.audit.changedvalue.mailserverchanged.username";
    @VisibleForTesting
    static final String TARGET_SYSTEM = "System";
    private static final Map<Class<? extends ApplicationConfigurationChangedEvent<?>>, String> APPLICATION_CONFIG_ACTION_KEY_MAPPING = ImmutableMap.builder().put(ApplicationSetupEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.action.applicationsetup").put(BaseUrlChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.action.baseurlchanged").put(DisplayNameChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.action.displaynamechanged").put(HttpScmHostingChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.action.httpscmchanged").put(MailHostConfigurationChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.action.mailserverchanged").put(ServerEmailAddressChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.action.serveremailaddresschanged").put(ServerTimeZoneChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.action.servertimezonechanged").build();
    private static final Map<Class<? extends ApplicationConfigurationChangedEvent<?>>, String> APPLICATION_CONFIG_CHANGED_VALUE_KEY_MAPPING = ImmutableMap.builder().put(BaseUrlChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.changedvalue.baseurlchanged.baseurl").put(DisplayNameChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.changedvalue.displaynamechanged.name").put(HttpScmHostingChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.changedvalue.httpscmchanged.accessenabled").put(ServerEmailAddressChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.changedvalue.serveremailaddresschanged.emailaddress").put(ServerTimeZoneChangedEvent.class, (Object)"bitbucket.service.applicationconfiguration.audit.changedvalue.servertimezonechanged.timezone").build();
    private static final Map<Class<? extends BackupEvent>, String> BACKUP_ACTION_KEY_MAPPING = ImmutableMap.builder().put(BackupCanceledEvent.class, (Object)"bitbucket.service.backup.audit.action.backupcancelled").put(BackupFailedEvent.class, (Object)"bitbucket.service.backup.audit.action.backupfailed").put(BackupStartedEvent.class, (Object)"bitbucket.service.backup.audit.action.backupstarted").put(BackupSucceededEvent.class, (Object)"bitbucket.service.backup.audit.action.backupsucceeded").build();
    private static final Map<Class<? extends MigrationEvent>, String> MIGRATION_ACTION_KEY_MAPPING = ImmutableMap.builder().put(MigrationCanceledEvent.class, (Object)"bitbucket.service.migration.audit.action.migrationcancelled").put(MigrationFailedEvent.class, (Object)"bitbucket.service.migration.audit.action.migrationfailed").put(MigrationStartedEvent.class, (Object)"bitbucket.service.migration.audit.action.migrationstarted").put(MigrationSucceededEvent.class, (Object)"bitbucket.service.migration.audit.action.migrationsucceeded").build();
    private final AuditService auditService;

    @Autowired
    public ServerEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onApplicationConfigurationChanged(ApplicationConfigurationChangedEvent<?> event) {
        String actionKey = APPLICATION_CONFIG_ACTION_KEY_MAPPING.getOrDefault(event.getClass(), event.getClass().getSimpleName());
        this.auditService.audit(ServerEventListener.addChangedValues(event, ServerEventListener.toAuditEventBuilder(actionKey)).build());
    }

    @EventListener
    public void onBackup(BackupEvent event) {
        String actionKey = BACKUP_ACTION_KEY_MAPPING.getOrDefault(event.getClass(), event.getClass().getSimpleName());
        this.auditService.audit(AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)actionKey).build()).build());
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent ignored) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)ACTION_LICENSE_CHANGED).build();
        this.auditService.audit(AuditEvent.builder((AuditType)type).build());
    }

    @EventListener
    public void onMigration(MigrationEvent event) {
        String actionKey = MIGRATION_ACTION_KEY_MAPPING.getOrDefault(event.getClass(), event.getClass().getSimpleName());
        this.auditService.audit(AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)actionKey).build()).build());
    }

    @EventListener
    public void onRepositoryArchivePolicyChangedEvent(RepositoryArchivePolicyChangedEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.permissions", (String)ACTION_REPO_ARCHIVE_CHANGED).build();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_POLICY).from(event.getOldPolicy().name()).to(event.getNewPolicy().name()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onRepositoryDeletePolicyChangedEvent(RepositoryDeletePolicyChangedEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.PERMISSIONS, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.permissions", (String)ACTION_REPO_DELETE_CHANGED).build();
        AuditEvent auditEvent = AuditEvent.builder((AuditType)type).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_POLICY).from(event.getOldPolicy().name()).to(event.getNewPolicy().name()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @EventListener
    public void onLoggingSettingsChangedEvent(LoggingSettingsChangedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.globaladministration", (String)(event.isEnabled() ? ACTION_LOGGING_ENABLED : ACTION_LOGGING_DISABLED)).build()).build());
    }

    @EventListener
    public void onProfilingSettingsChangedEvent(ProfilingSettingsChangedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.globaladministration", (String)(event.isEnabled() ? ACTION_PROFILING_ENABLED : ACTION_PROFILING_DISABLED)).build()).build());
    }

    private static AuditEvent.Builder addChangedValues(ApplicationConfigurationChangedEvent<?> event, AuditEvent.Builder builder) {
        boolean hasNewValue;
        boolean hasOldValue = event.getOldValue() != null;
        boolean bl = hasNewValue = event.getNewValue() != null;
        if (event instanceof MailHostConfigurationChangedEvent) {
            MailHostConfigurationChangedEvent mailHostEvent = (MailHostConfigurationChangedEvent)event;
            MailHostConfiguration oldConfig = (MailHostConfiguration)mailHostEvent.getOldValue();
            MailHostConfiguration newConfig = (MailHostConfiguration)mailHostEvent.getNewValue();
            return builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_HOSTNAME).from(hasOldValue ? oldConfig.getHostname() : null).to(hasNewValue ? newConfig.getHostname() : null).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PORT).from(hasOldValue ? String.valueOf(oldConfig.getPort()) : null).to(hasNewValue ? String.valueOf(newConfig.getPort()) : null).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_USERNAME).from(hasOldValue ? oldConfig.getUsername() : null).to(hasNewValue ? newConfig.getUsername() : null).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_PROTOCOL).from(hasOldValue ? oldConfig.getProtocol().name() : null).to(hasNewValue ? newConfig.getProtocol().name() : null).build());
        }
        String changedValueKey = APPLICATION_CONFIG_CHANGED_VALUE_KEY_MAPPING.get(event.getClass());
        if (changedValueKey == null) {
            return builder;
        }
        return builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)changedValueKey).from(hasOldValue ? String.valueOf(event.getOldValue()) : null).to(hasNewValue ? String.valueOf(event.getNewValue()) : null).build());
    }

    private static AuditEvent.Builder toAuditEventBuilder(String actionKey) {
        return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.globaladministration", (String)actionKey).build());
    }
}

