/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.user.UserErasedEvent;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserEventListener {
    @VisibleForTesting
    static final String ACTION_USER_ERASED = "bitbucket.user.audit.action.usererased";
    @VisibleForTesting
    static final String ATTR_ERASED_USER_ID = "bitbucket.user.audit.attribute.usererased.eraseduserid";
    @VisibleForTesting
    static final String ATTR_NEW_IDENTIFIER = "bitbucket.user.audit.attribute.usererased.newidentifier";
    @VisibleForTesting
    static final String ATTR_ORIGINAL_USERNAME = "bitbucket.user.audit.attribute.usererased.originalusername";
    private final AuditService auditService;

    @Autowired
    public UserEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onUserErased(UserErasedEvent event) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)ACTION_USER_ERASED).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)type).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ERASED_USER_ID, (String)Integer.toString(event.getUpdatedUser().getId())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_NEW_IDENTIFIER, (String)event.getUpdatedUser().getName()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ORIGINAL_USERNAME, (String)event.getOriginalUsername()).build());
        this.auditService.audit(builder.build());
    }
}

