/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.user.UserExportEvent;
import com.atlassian.bitbucket.dmz.user.UserExportFailedEvent;
import com.atlassian.bitbucket.dmz.user.UserExportStartedEvent;
import com.atlassian.bitbucket.dmz.user.UserExportSucceededEvent;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserExportEventListener {
    private static final String AUDIT_ACTION_I18N_KEY_PREFIX = "bitbucket.user.export.audit.action.";
    private static final String AUDIT_ATTR_I18N_KEY_PREFIX = "bitbucket.user.export.audit.attribute.";
    @VisibleForTesting
    static final String ACTION_PERMISSIONS_EXPORT_FAILED = "bitbucket.user.export.audit.action.permissionsexportfailed";
    @VisibleForTesting
    static final String ACTION_PERMISSIONS_EXPORT_STARTED = "bitbucket.user.export.audit.action.permissionsexportstarted";
    @VisibleForTesting
    static final String ACTION_PERMISSIONS_EXPORT_SUCCEEDED = "bitbucket.user.export.audit.action.permissionsexportsucceeded";
    @VisibleForTesting
    static final String ACTION_USERS_EXPORT_FAILED = "bitbucket.user.export.audit.action.usersexportfailed";
    @VisibleForTesting
    static final String ACTION_USERS_EXPORT_STARTED = "bitbucket.user.export.audit.action.usersexportstarted";
    @VisibleForTesting
    static final String ACTION_USERS_EXPORT_SUCCEEDED = "bitbucket.user.export.audit.action.usersexportsucceeded";
    @VisibleForTesting
    static final String ATTR_ROWS_EXPORTED = "bitbucket.user.export.audit.attribute.rowsexported";
    @VisibleForTesting
    static final String ATTR_DURATION = "bitbucket.user.export.audit.attribute.duration";
    @VisibleForTesting
    static final String ATTR_LICENSE_STATUS = "bitbucket.user.export.audit.attribute.licenseStatus";
    @VisibleForTesting
    static final String ATTR_FILTER_TEXT = "bitbucket.user.export.audit.attribute.filterText";
    @VisibleForTesting
    static final String ATTR_DIRECTORY_NAME = "bitbucket.user.export.audit.attribute.directoryName";
    @VisibleForTesting
    static final String ATTR_LAST_ACTIVE_BEFORE = "bitbucket.user.export.audit.attribute.lastActiveBefore";
    @VisibleForTesting
    static final String ATTR_LAST_ACTIVE_AFTER = "bitbucket.user.export.audit.attribute.lastActiveAfter";
    private final AuditService auditService;

    @Autowired
    public UserExportEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onUserExportFailed(UserExportFailedEvent event) {
        AuditEvent.Builder auditEventBuilder = this.buildAuditEvent(event.isWithPermissions() ? ACTION_PERMISSIONS_EXPORT_FAILED : ACTION_USERS_EXPORT_FAILED).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DURATION, (String)String.valueOf(event.getDuration())).build());
        this.auditService.audit(this.enrichUserExportEvent(auditEventBuilder, (UserExportEvent)event).build());
    }

    @EventListener
    public void onUserExportStarted(UserExportStartedEvent event) {
        AuditEvent.Builder auditEventBuilder = this.buildAuditEvent(event.isWithPermissions() ? ACTION_PERMISSIONS_EXPORT_STARTED : ACTION_USERS_EXPORT_STARTED);
        this.auditService.audit(this.enrichUserExportEvent(auditEventBuilder, (UserExportEvent)event).build());
    }

    @EventListener
    public void onUserExportSucceeded(UserExportSucceededEvent event) {
        AuditEvent.Builder auditEventBuilder = this.buildAuditEvent(event.isWithPermissions() ? ACTION_PERMISSIONS_EXPORT_SUCCEEDED : ACTION_USERS_EXPORT_SUCCEEDED).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ROWS_EXPORTED, (String)Integer.toString(event.getRowsExported())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DURATION, (String)String.valueOf(event.getDuration())).build());
        this.auditService.audit(this.enrichUserExportEvent(auditEventBuilder, (UserExportEvent)event).build());
    }

    private AuditEvent.Builder buildAuditEvent(String action) {
        return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.usersandgroups", (String)action).build());
    }

    private AuditEvent.Builder enrichUserExportEvent(AuditEvent.Builder auditEventBuilder, UserExportEvent event) {
        event.getFilterText().ifPresent(filterText -> auditEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_FILTER_TEXT, (String)filterText).build()));
        event.getDirectoryName().ifPresent(directoryName -> auditEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DIRECTORY_NAME, (String)directoryName).build()));
        event.getLastActiveAfter().ifPresent(lastActiveAfter -> auditEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_LAST_ACTIVE_AFTER, (String)lastActiveAfter.toString()).build()));
        event.getLastActiveBefore().ifPresent(lastActiveBefore -> auditEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_LAST_ACTIVE_BEFORE, (String)lastActiveBefore.toString()).build()));
        event.getLicenseStatus().ifPresent(status -> auditEventBuilder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_LICENSE_STATUS, (String)status.toString()).build()));
        return auditEventBuilder;
    }
}

