/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.event.watch.WatcherAddedEvent;
import com.atlassian.bitbucket.event.watch.WatcherRemovedEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.event.api.EventListener;
import jakarta.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class WatcherEventListener {
    private final WatcherEventAuditor addedEventAuditor;
    private final WatcherEventAuditor removedEventAuditor;

    public WatcherEventListener(AuditService auditService) {
        this.addedEventAuditor = new WatcherEventAuditor(auditService, WatcherAction.ADDED);
        this.removedEventAuditor = new WatcherEventAuditor(auditService, WatcherAction.REMOVED);
    }

    @EventListener
    public void onWatcherAdded(WatcherAddedEvent event) {
        event.getWatcher().getWatchable().accept((WatchableVisitor)this.addedEventAuditor);
    }

    @EventListener
    public void onWatcherRemoved(WatcherRemovedEvent event) {
        event.getWatcher().getWatchable().accept((WatchableVisitor)this.removedEventAuditor);
    }

    private static class WatcherEventAuditor
    implements WatchableVisitor<Void> {
        private final AuditService auditService;
        private final WatcherAction watcherAction;

        public WatcherEventAuditor(AuditService auditService, WatcherAction watcherAction) {
            this.auditService = auditService;
            this.watcherAction = watcherAction;
        }

        public Void visit(@Nonnull CommitDiscussion discussion) {
            return null;
        }

        public Void visit(@Nonnull PullRequest pullRequest) {
            AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.pullrequests", (String)this.watcherAction.toPullRequestAction()).build();
            AuditEvent auditEvent = AuditEvent.builder((AuditType)type).affectedObjects(AuditUtils.auditResourcesForProjectRepositoryPullRequest((PullRequest)pullRequest)).build();
            this.auditService.audit(auditEvent);
            return null;
        }

        public Void visit(@Nonnull Repository repository) {
            AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.END_USER_ACTIVITY, (CoverageLevel)CoverageLevel.FULL, (String)"bitbucket.service.audit.category.repositories", (String)this.watcherAction.toRepositoryAction()).build();
            AuditEvent auditEvent = AuditEvent.builder((AuditType)type).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repository)).build();
            this.auditService.audit(auditEvent);
            return null;
        }
    }

    private static enum WatcherAction {
        ADDED("bitbucket.notification.audit.action.%swatcheradded"),
        REMOVED("bitbucket.notification.audit.action.%swatcherremoved");

        private final String actionKeyFormat;

        private WatcherAction(String actionKeyFormat) {
            this.actionKeyFormat = actionKeyFormat;
        }

        public String toPullRequestAction() {
            return String.format(this.actionKeyFormat, "pullrequest");
        }

        public String toRepositoryAction() {
            return String.format(this.actionKeyFormat, "repository");
        }
    }
}

