/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit.enrichment;

import com.atlassian.audit.core.spi.service.CurrentUserProvider;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAuditAuthorProvider
implements CurrentUserProvider {
    private final AuthenticationContext authenticationContext;
    private final RequestManager requestManager;

    @Autowired
    public DefaultAuditAuthorProvider(AuthenticationContext authenticationContext, RequestManager requestManager) {
        this.authenticationContext = authenticationContext;
        this.requestManager = requestManager;
    }

    @Nonnull
    public AuditAuthor currentUser() {
        RequestMetadata requestMetadata = this.requestManager.getRequestMetadata();
        if (requestMetadata == null) {
            return AuditAuthor.SYSTEM_AUTHOR;
        }
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            return AuditAuthor.ANONYMOUS_AUTHOR;
        }
        return AuditUtils.auditAuthorForUser((ApplicationUser)currentUser);
    }
}

