/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit.enrichment;

import com.atlassian.audit.core.spi.AuditMethods;
import com.atlassian.audit.core.spi.service.AuditMethodProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.stash.internal.auth.Oauth2RequestContext;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAuditMethodProvider
implements AuditMethodProvider {
    private final Oauth2RequestContext oauth2RequestContext;
    private final RequestManager requestManager;

    @Autowired
    public DefaultAuditMethodProvider(Oauth2RequestContext oauth2RequestContext, RequestManager requestManager) {
        this.oauth2RequestContext = oauth2RequestContext;
        this.requestManager = requestManager;
    }

    @Nonnull
    public String currentMethod() {
        Optional<String> oauth2ApplicationName = this.oauth2RequestContext.getApplicationNameForRequest();
        if (oauth2ApplicationName.isPresent()) {
            return oauth2ApplicationName.get() + " - OAuth";
        }
        RequestMetadata requestMetadata = this.requestManager.getRequestMetadata();
        return requestMetadata == null ? AuditMethods.system() : AuditMethods.browser();
    }
}

