/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit.enrichment;

import com.atlassian.audit.core.spi.service.IpAddressProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIpAddressProvider
implements IpAddressProvider {
    private final RequestManager requestManager;

    @Autowired
    public DefaultIpAddressProvider(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    @Nullable
    public String currentIpAddress() {
        RequestMetadata requestMetadata = this.requestManager.getRequestMetadata();
        return requestMetadata == null ? null : requestMetadata.getRemoteAddress();
    }

    @Nonnull
    public Optional<String> forwarderIpAddress() {
        return this.getRemoteIpAddresses().map(a -> {
            String[] addresses = a.split(",");
            return addresses.length > 1 ? addresses[1].trim() : null;
        });
    }

    @Nullable
    public String remoteIpAddress() {
        return this.getRemoteIpAddresses().map(a -> a.split(",")[0].trim()).orElse(null);
    }

    private Optional<String> getRemoteIpAddresses() {
        return Optional.ofNullable(this.requestManager.getRequestMetadata()).map(RequestMetadata::getRemoteAddress);
    }
}

