/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit.external;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.applinks.api.event.ApplicationLinksIDChangedEvent;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationLinksEventListener {
    @VisibleForTesting
    static final String ACTION_APP_LINK_ADDED = "bitbucket.service.applink.audit.action.applicationlinkadded";
    @VisibleForTesting
    static final String ACTION_APP_LINK_DELETED = "bitbucket.service.applink.audit.action.applicationlinkdeleted";
    @VisibleForTesting
    static final String ACTION_APP_LINK_UPDATED = "bitbucket.service.applink.audit.action.applicationlinkupdated";
    @VisibleForTesting
    static final String ATTR_APP_LINK_DISPLAY_URL = "bitbucket.service.applink.audit.attribute.applicationlinkupdated.displayurl";
    @VisibleForTesting
    static final String ATTR_APP_LINK_PRIMARY = "bitbucket.service.applink.audit.attribute.applicationlinkupdated.primary";
    @VisibleForTesting
    static final String ATTR_APP_LINK_TYPE = "bitbucket.service.applink.audit.attribute.applicationlinkupdated.type";
    @VisibleForTesting
    static final String KEY_APP_LINK_ID = "bitbucket.service.applink.audit.changedvalue.applicationlinkupdated.id";
    @VisibleForTesting
    static final String KEY_APP_LINK_NAME = "bitbucket.service.applink.audit.changedvalue.applicationlinkupdated.name";
    private final AuditService auditService;

    @Autowired
    public ApplicationLinksEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onApplicationLinkAddedEvent(ApplicationLinkAddedEvent event) {
        this.auditService.audit(ApplicationLinksEventListener.auditEventBuilder(ACTION_APP_LINK_ADDED, event.getApplicationLink()).build());
    }

    @EventListener
    public void onApplicationLinkDeletedEvent(ApplicationLinkDeletedEvent event) {
        this.auditService.audit(ApplicationLinksEventListener.auditEventBuilder(ACTION_APP_LINK_DELETED, event.getApplicationLink()).build());
    }

    @EventListener
    public void onApplicationLinkDetailsChangedEvent(ApplicationLinkDetailsChangedEvent event) {
        Optional oldApplicationLink = event.getOldApplicationLink();
        ApplicationLink updatedApplicationLink = event.getApplicationLink();
        this.auditService.audit(ApplicationLinksEventListener.auditEventBuilder(ACTION_APP_LINK_UPDATED, updatedApplicationLink).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_APP_LINK_NAME).from((String)oldApplicationLink.map(ReadOnlyApplicationLink::getName).orElse(null)).to(updatedApplicationLink.getName()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_APP_LINK_DISPLAY_URL).from((String)oldApplicationLink.map(ReadOnlyApplicationLink::getDisplayUrl).map(URI::toASCIIString).orElse(null)).to(updatedApplicationLink.getDisplayUrl().toASCIIString()).build()).build());
    }

    @EventListener
    public void onApplicationLinkIDChangedEvent(ApplicationLinksIDChangedEvent event) {
        ApplicationLink applicationLink = event.getApplicationLink();
        this.auditService.audit(AuditEvent.builder((AuditType)ApplicationLinksEventListener.getAuditType(ACTION_APP_LINK_UPDATED)).changedValue(ChangedValue.fromI18nKeys((String)KEY_APP_LINK_ID).from(event.getOldApplicationId().get()).to(applicationLink.getId().get()).build()).affectedObject(AuditUtils.auditResourceForAppLink((ApplicationLink)applicationLink)).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_APP_LINK_TYPE, (String)applicationLink.getType().getI18nKey()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_APP_LINK_PRIMARY, (String)String.valueOf(applicationLink.isPrimary())).build()).build());
    }

    private static AuditEvent.Builder auditEventBuilder(String action, ApplicationLink link) {
        return new AuditEvent.Builder(ApplicationLinksEventListener.getAuditType(action)).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_APP_LINK_TYPE, (String)link.getType().getI18nKey()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_APP_LINK_PRIMARY, (String)String.valueOf(link.isPrimary())).build()).affectedObject(AuditUtils.auditResourceForAppLink((ApplicationLink)link));
    }

    private static AuditType getAuditType(String action) {
        return AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.globaladministration", (String)action).build();
    }
}

