/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit.external;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.group.AutoGroupCreatedEvent;
import com.atlassian.crowd.event.group.AutoGroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.AutoUserCreatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCreatedFromDirectorySynchronisationEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrowdEventListener {
    @VisibleForTesting
    static final String ACTION_AUTO_GROUP_CREATED = "bitbucket.service.user.audit.action.autogroupcreated";
    @VisibleForTesting
    static final String ACTION_AUTO_GROUP_MEMBERSHIP_DELETED = "bitbucket.service.user.audit.action.autogroupmembershipdeleted";
    @VisibleForTesting
    static final String ACTION_AUTO_USER_CREATED = "bitbucket.service.user.audit.action.autousercreated";
    @VisibleForTesting
    static final String ACTION_DIRECTORY_CREATED = "bitbucket.service.user.audit.action.directorycreated";
    @VisibleForTesting
    static final String ACTION_DIRECTORY_DELETED = "bitbucket.service.user.audit.action.directorydeleted";
    @VisibleForTesting
    static final String ACTION_GROUP_CREATED = "bitbucket.service.user.audit.action.groupcreated";
    @VisibleForTesting
    static final String ACTION_GROUP_DELETED = "bitbucket.service.user.audit.action.groupdeleted";
    @VisibleForTesting
    static final String ACTION_GROUP_MEMBERSHIPS_CREATED_USER = "bitbucket.service.user.audit.action.groupmembershipscreated.user";
    @VisibleForTesting
    static final String ACTION_GROUP_MEMBERSHIPS_CREATED_GROUP = "bitbucket.service.user.audit.action.groupmembershipscreated.group";
    @VisibleForTesting
    static final String ACTION_GROUP_MEMBERSHIP_DELETED = "bitbucket.service.user.audit.action.groupmembershipdeleted";
    @VisibleForTesting
    static final String ACTION_GROUP_UPDATED = "bitbucket.service.user.audit.action.groupupdated";
    @VisibleForTesting
    static final String ACTION_USER_CREATED = "bitbucket.service.user.audit.action.usercreated";
    @VisibleForTesting
    static final String ACTION_USER_CREATED_FROM_DIRECTORY_SYNC = "bitbucket.service.user.audit.action.usercreatedfromdirectorysynchronisation";
    @VisibleForTesting
    static final String ACTION_USER_CREDENTIALS_UPDATED = "bitbucket.service.user.audit.action.usercredentialupdated";
    @VisibleForTesting
    static final String ACTION_USER_DELETED = "bitbucket.service.user.audit.action.userdeleted";
    @VisibleForTesting
    static final String ACTION_USER_RENAMED = "bitbucket.service.user.audit.action.userrenamed";
    @VisibleForTesting
    static final String ATTR_DIRECTORY_NAME = "bitbucket.service.user.audit.attribute.directory.name";
    @VisibleForTesting
    static final String ATTR_PARENT_GROUP = "bitbucket.service.user.audit.attribute.groupmembership.parentgroup";
    @VisibleForTesting
    static final String ATTR_USER_NAME = "bitbucket.service.user.audit.attribute.user.name";
    private final ApplicationUserDao applicationUserDao;
    private final AuditService auditService;

    @Autowired
    public CrowdEventListener(ApplicationUserDao applicationUserDao, AuditService auditService) {
        this.auditService = auditService;
        this.applicationUserDao = applicationUserDao;
    }

    @EventListener
    public void onDirectoryCreated(DirectoryCreatedEvent event) {
        String directoryName = event.getDirectory().getName();
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)ACTION_DIRECTORY_CREATED).build();
        this.auditService.audit(AuditEvent.builder((AuditType)auditType).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DIRECTORY_NAME, (String)directoryName).build()).build());
    }

    @EventListener
    public void onDirectoryDeleted(DirectoryDeletedEvent event) {
        String directoryName = event.getDirectory().getName();
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)ACTION_DIRECTORY_DELETED).build();
        this.auditService.audit(AuditEvent.builder((AuditType)auditType).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DIRECTORY_NAME, (String)directoryName).build()).build());
    }

    @EventListener
    public void onGroupCreated(GroupCreatedEvent event) {
        if (CrowdEventListener.isAudited((DirectoryEvent)event)) {
            String actionI18nKey = event instanceof AutoGroupCreatedEvent ? ACTION_AUTO_GROUP_CREATED : ACTION_GROUP_CREATED;
            this.auditService.audit(CrowdEventListener.toGroupAuditEventBuilder(event.getGroup().getName(), actionI18nKey).build());
        }
    }

    @EventListener
    public void onGroupDeleted(GroupDeletedEvent event) {
        if (CrowdEventListener.isAudited((DirectoryEvent)event)) {
            this.auditService.audit(CrowdEventListener.toGroupAuditEventBuilder(event.getGroupName(), ACTION_GROUP_DELETED).build());
        }
    }

    @EventListener
    public void onGroupUpdated(GroupUpdatedEvent event) {
        if (CrowdEventListener.isAudited((DirectoryEvent)event)) {
            this.auditService.audit(CrowdEventListener.toGroupAuditEventBuilder(event.getGroup().getName(), ACTION_GROUP_UPDATED).build());
        }
    }

    @EventListener
    public void onGroupMembershipsCreated(GroupMembershipsCreatedEvent event) {
        if (CrowdEventListener.isAudited((DirectoryEvent)event)) {
            String actionI18nKey;
            MembershipType membershipType = event.getMembershipType();
            switch (membershipType) {
                case GROUP_USER: {
                    actionI18nKey = ACTION_GROUP_MEMBERSHIPS_CREATED_USER;
                    break;
                }
                case GROUP_GROUP: {
                    actionI18nKey = ACTION_GROUP_MEMBERSHIPS_CREATED_GROUP;
                    break;
                }
                default: {
                    return;
                }
            }
            event.getEntityNames().forEach(entity -> {
                AuditEvent.Builder builder = CrowdEventListener.toGroupAuditEventBuilder(event.getGroupName(), actionI18nKey);
                if (membershipType == MembershipType.GROUP_USER) {
                    builder.affectedObject(CrowdEventListener.toAuditResource((ApplicationUser)this.applicationUserDao.findByName(entity), entity));
                } else {
                    builder.affectedObject(AuditUtils.auditResourceForGroup((String)entity));
                }
                this.auditService.audit(builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PARENT_GROUP, (String)event.getGroupName()).build()).build());
            });
        }
    }

    @EventListener
    public void onGroupMembershipDeleted(GroupMembershipDeletedEvent event) {
        if (CrowdEventListener.isAudited((DirectoryEvent)event)) {
            String actionI18nKey = event instanceof AutoGroupMembershipDeletedEvent ? ACTION_AUTO_GROUP_MEMBERSHIP_DELETED : ACTION_GROUP_MEMBERSHIP_DELETED;
            String entityName = event.getEntityName();
            this.auditService.audit(CrowdEventListener.toGroupAuditEventBuilder(event.getGroupName(), actionI18nKey).affectedObject(CrowdEventListener.toAuditResource((ApplicationUser)this.applicationUserDao.findByName(entityName), entityName)).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PARENT_GROUP, (String)event.getGroupName()).build()).build());
        }
    }

    @EventListener
    public void onUserCreated(UserCreatedEvent event) {
        if (CrowdEventListener.isAudited((DirectoryEvent)event)) {
            String actionI18nKey = event instanceof AutoUserCreatedEvent ? ACTION_AUTO_USER_CREATED : (event instanceof UserCreatedFromDirectorySynchronisationEvent ? ACTION_USER_CREATED_FROM_DIRECTORY_SYNC : ACTION_USER_CREATED);
            InternalNormalUser internalUser = this.applicationUserDao.loadUser((User)event.getUser());
            this.auditService.audit(CrowdEventListener.toUserAuditEventBuilder((ApplicationUser)internalUser, event.getUser().getName(), actionI18nKey).build());
        }
    }

    @EventListener
    public void onUserCredentialUpdated(UserCredentialUpdatedEvent event) {
        InternalNormalUser internalUser = this.applicationUserDao.findByName(event.getUsername());
        this.auditService.audit(CrowdEventListener.toUserAuditEventBuilder((ApplicationUser)internalUser, event.getUsername(), ACTION_USER_CREDENTIALS_UPDATED).build());
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent event) {
        if (CrowdEventListener.isAudited((DirectoryEvent)event)) {
            this.auditService.audit(CrowdEventListener.toUserAuditEventBuilder(null, event.getUsername(), ACTION_USER_DELETED).build());
        }
    }

    @EventListener
    public void onUserRenamed(UserRenamedEvent event) {
        if (CrowdEventListener.isAudited((DirectoryEvent)event)) {
            AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)ACTION_USER_RENAMED).build();
            String newUsername = event.getUser().getName();
            String oldUsername = event.getOldUsername();
            InternalNormalUser internalUser = this.applicationUserDao.loadUser((User)event.getUser());
            AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).affectedObject(CrowdEventListener.toAuditResource((ApplicationUser)internalUser, newUsername)).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_USER_NAME).from(oldUsername).to(newUsername).build());
            this.auditService.audit(builder.build());
        }
    }

    private static boolean isAudited(DirectoryEvent event) {
        DirectoryType directoryType = event.getDirectory().getType();
        return directoryType == DirectoryType.INTERNAL || directoryType == DirectoryType.DELEGATING;
    }

    private static AuditResource toAuditResource(ApplicationUser internalUser, String username) {
        return internalUser == null ? AuditResource.builder((String)username, (String)"USER").build() : AuditUtils.auditResourceForUser((ApplicationUser)internalUser);
    }

    private static AuditEvent.Builder toGroupAuditEventBuilder(String groupName, String actionI18nKey) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)actionI18nKey).build();
        return AuditEvent.builder((AuditType)auditType).affectedObject(AuditUtils.auditResourceForGroup((String)groupName));
    }

    private static AuditEvent.Builder toUserAuditEventBuilder(ApplicationUser internalUser, String username, String actionI18nKey) {
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.usersandgroups", (String)actionI18nKey).build();
        return AuditEvent.builder((AuditType)auditType).affectedObject(CrowdEventListener.toAuditResource(internalUser, username));
    }
}

