/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit.external;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.events.PluginContainerUnavailableEvent;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginInstalledEvent;
import com.atlassian.plugin.event.events.PluginModuleAvailableEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleUnavailableEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginEventListener {
    private static final String PLUGIN_AUDIT_ACTION_KEYS_PREFIX = "bitbucket.service.plugin.audit.action.";
    private static final String PLUGIN_AUDIT_ATTRIBUTE_KEYS_PREFIX = "bitbucket.service.plugin.audit.attribute.";
    private static final String PLUGIN_CONTAINER_AUDIT_ACTION_KEYS_PREFIX = "bitbucket.service.plugincontainer.audit.action.";
    private static final String PLUGIN_FRAMEWORK_AUDIT_ACTION_KEYS_PREFIX = "bitbucket.service.pluginframework.audit.action.";
    private static final String PLUGIN_MODULE_AUDIT_ACTION_KEYS_PREFIX = "bitbucket.service.pluginmodule.audit.action.";
    @VisibleForTesting
    static final String ACTION_PLUGIN_DISABLED = "bitbucket.service.plugin.audit.action.plugindisabled";
    @VisibleForTesting
    static final String ACTION_PLUGIN_ENABLED = "bitbucket.service.plugin.audit.action.pluginenabled";
    @VisibleForTesting
    static final String ACTION_PLUGIN_UNINSTALLED = "bitbucket.service.plugin.audit.action.pluginuninstalled";
    @VisibleForTesting
    static final String ACTION_PLUGIN_INSTALLED = "bitbucket.service.plugin.audit.action.plugininstalled";
    @VisibleForTesting
    static final String ACTION_PLUGIN_UPGRADED = "bitbucket.service.plugin.audit.action.pluginupgraded";
    @VisibleForTesting
    static final String ACTION_PLUGIN_CONTAINER_UNAVAILABLE = "bitbucket.service.plugincontainer.audit.action.plugincontainerunavailable";
    @VisibleForTesting
    static final String ACTION_PLUGIN_FRAMEWORK_STARTED = "bitbucket.service.pluginframework.audit.action.pluginframeworkstarted";
    @VisibleForTesting
    static final String ACTION_PLUGIN_MODULE_AVAILABLE = "bitbucket.service.pluginmodule.audit.action.pluginmoduleavailable";
    @VisibleForTesting
    static final String ACTION_PLUGIN_MODULE_DISABLED = "bitbucket.service.pluginmodule.audit.action.pluginmoduledisabled";
    @VisibleForTesting
    static final String ACTION_PLUGIN_MODULE_ENABLED = "bitbucket.service.pluginmodule.audit.action.pluginmoduleenabled";
    @VisibleForTesting
    static final String ACTION_PLUGIN_MODULE_UNAVAILABLE = "bitbucket.service.pluginmodule.audit.action.pluginmoduleunavailable";
    @VisibleForTesting
    static final String ATTR_PLUGIN_VERSION = "bitbucket.service.plugin.audit.attribute.version";
    @VisibleForTesting
    static final String ATTR_PLUGIN_NAME = "bitbucket.service.plugin.audit.attribute.pluginname";
    private final AuditService auditService;

    @Autowired
    public PluginEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onPluginContainerUnavailable(PluginContainerUnavailableEvent ignored) {
        this.auditService.audit(PluginEventListener.auditEventBuilder(CoverageLevel.FULL, ACTION_PLUGIN_CONTAINER_UNAVAILABLE).build());
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.auditPluginEvent(ACTION_PLUGIN_DISABLED, event.getPlugin());
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.auditPluginEvent(ACTION_PLUGIN_ENABLED, event.getPlugin());
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        this.auditService.audit(PluginEventListener.auditEventBuilder(CoverageLevel.FULL, ACTION_PLUGIN_FRAMEWORK_STARTED).build());
    }

    @EventListener
    public void onPluginModuleAvailable(PluginModuleAvailableEvent event) {
        this.auditPluginModuleEvent(ACTION_PLUGIN_MODULE_AVAILABLE, event.getModule().getCompleteKey());
    }

    @EventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.auditPluginModuleEvent(ACTION_PLUGIN_MODULE_DISABLED, event.getModule().getCompleteKey());
    }

    @EventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.auditPluginModuleEvent(ACTION_PLUGIN_MODULE_ENABLED, event.getModule().getCompleteKey());
    }

    @EventListener
    public void onPluginModuleUnavailable(PluginModuleUnavailableEvent event) {
        this.auditPluginModuleEvent(ACTION_PLUGIN_MODULE_UNAVAILABLE, event.getModule().getCompleteKey());
    }

    @EventListener
    public void onPluginUninstalled(PluginUninstalledEvent event) {
        this.auditPluginEvent(ACTION_PLUGIN_UNINSTALLED, event.getPlugin());
    }

    @EventListener
    public void onPluginInstalled(PluginInstalledEvent event) {
        this.auditPluginEvent(ACTION_PLUGIN_INSTALLED, event.getPlugin());
    }

    @EventListener
    public void onPluginUpgraded(PluginUpgradedEvent event) {
        this.auditPluginEvent(ACTION_PLUGIN_UPGRADED, event.getPlugin());
    }

    private static AuditEvent.Builder auditEventBuilder(CoverageLevel coverageLevel, String actionKey) {
        return AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)coverageLevel, (String)"bitbucket.service.audit.category.apps", (String)actionKey).build());
    }

    private void auditPluginEvent(String action, Plugin plugin) {
        this.auditService.audit(PluginEventListener.auditEventBuilder(CoverageLevel.BASE, action).affectedObject(AuditUtils.miscellaneousAuditResource((String)plugin.getKey())).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PLUGIN_NAME, (String)plugin.getName()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PLUGIN_VERSION, (String)plugin.getPluginInformation().getVersion()).build()).build());
    }

    private void auditPluginModuleEvent(String action, String moduleKey) {
        this.auditService.audit(PluginEventListener.auditEventBuilder(CoverageLevel.FULL, action).affectedObject(AuditUtils.miscellaneousAuditResource((String)moduleKey)).build());
    }
}

