/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.AuthenticationState;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class BasicAuthChallengeFailureHandler
implements HttpAuthenticationFailureHandler {
    private final I18nService i18nService;

    public BasicAuthChallengeFailureHandler(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException {
        if (!"basic".equals(context.getMethod())) {
            return false;
        }
        HttpServletResponse response = context.getResponse();
        response.addHeader("WWW-Authenticate", "Basic realm=\"" + Product.FULL_NAME + "\"");
        response.sendError(401, this.getMessage(context.getAuthenticationState()));
        return true;
    }

    private String getMessage(AuthenticationState reason) {
        switch (reason) {
            case CAPTCHA_REQUIRED: {
                return this.i18nService.getMessage("bitbucket.auth.failed.captcha.required", new Object[]{Product.NAME});
            }
            case UNLICENSED: {
                return this.i18nService.getMessage("bitbucket.auth.failed.unlicensed.user", new Object[]{Product.NAME});
            }
        }
        return this.i18nService.getMessage("bitbucket.auth.failed.credentials", new Object[0]);
    }
}

