/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.dmz.auth.ScopesRequestCacheDelegate;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.auth.OAuthRequestVerifierFactory;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="anonymous2LORequestVerifier")
@AvailableToPlugins(value=Anonymous2LORequestVerifier.class)
public class DefaultAnonymous2LORequestVerifier
implements Anonymous2LORequestVerifier {
    private final AuthenticationContext authenticationContext;
    private final OsgiContainerManager osgiContainerManager;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private ServiceTracker<OAuthRequestVerifierFactory, OAuthRequestVerifierFactory> serviceTracker;

    @Autowired
    public DefaultAnonymous2LORequestVerifier(AuthenticationContext authenticationContext, OsgiContainerManager osgiContainerManager, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.authenticationContext = authenticationContext;
        this.osgiContainerManager = osgiContainerManager;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    public boolean isValid(@Nonnull String scope) {
        return this.isValid(Set.of(scope));
    }

    public boolean isValid(@Nonnull Collection<String> scopes) {
        Objects.requireNonNull(scopes, "scopes");
        return this.isAnonymous() && (this.isValidOAuth1Internal() || this.scopesRequestCacheDelegate.isAnyScopePermitted(scopes));
    }

    public boolean isValidOAuth1() {
        return this.isAnonymous() && this.isValidOAuth1Internal();
    }

    public boolean isValidOAuth2(@Nonnull Collection<String> scopes) {
        return this.isAnonymous() && this.scopesRequestCacheDelegate.isAnyScopePermitted(scopes);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        this.serviceTracker = this.osgiContainerManager.getServiceTracker(OAuthRequestVerifierFactory.class.getName());
    }

    private Optional<OAuthRequestVerifierFactory> getOAuthRequestVerifierFactory() {
        if (this.serviceTracker != null) {
            return Optional.ofNullable((OAuthRequestVerifierFactory)this.serviceTracker.getService());
        }
        return Optional.empty();
    }

    private boolean isAnonymous() {
        return !this.authenticationContext.isAuthenticated();
    }

    private boolean isValidOAuth1Internal() {
        return this.getOAuthRequestVerifierFactory().map(factory -> factory.getInstance(null).isVerified()).orElse(false);
    }
}

