/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class DefaultAuthenticationContext
implements InternalAuthenticationContext,
StatefulService {
    public boolean isAuthenticated() {
        return this.getCurrentUser() != null;
    }

    public ApplicationUser getCurrentUser() {
        StashUserAuthenticationToken token = this.getCurrentToken();
        return token == null ? null : token.getPrincipal();
    }

    public StashUserAuthenticationToken getCurrentToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)authentication;
        }
        return null;
    }

    @Nonnull
    public Map<String, Serializable> getProperties() {
        StashUserAuthenticationToken token = this.getCurrentToken();
        return token == null ? Collections.emptyMap() : token.getProperties();
    }

    public void refreshUser(@Nonnull ApplicationUser updatedUser) {
        Objects.requireNonNull(updatedUser, "updatedUser");
        StashUserAuthenticationToken currentToken = this.getCurrentToken();
        if (currentToken == null) {
            throw new IllegalStateException("No current user available to update.");
        }
        ApplicationUser currentUser = currentToken.getPrincipal();
        if (currentUser == null) {
            throw new IllegalStateException("No current user available to update.");
        }
        if (currentUser.getId() != updatedUser.getId()) {
            throw new IllegalArgumentException("Current and passed user are not the same.");
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)currentToken.copyWithUser(updatedUser));
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        final Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return new TransferableState(){

            public void apply() {
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }

            public void remove() {
                SecurityContextHolder.clearContext();
            }
        };
    }
}

