/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.internal.auth.AuthenticationHelper;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component(value="authenticationHelper")
public class DefaultAuthenticationHelper
implements AuthenticationHelper {
    static final String ATTR_CACHED_USERNAME = "bitbucket.cached-username";

    public AuthenticationException getAuthenticationException(@Nonnull HttpServletRequest request) {
        return (AuthenticationException)DefaultAuthenticationHelper.getAttribute(request, "SPRING_SECURITY_LAST_EXCEPTION");
    }

    public String getCachedUsername(@Nonnull HttpServletRequest request) {
        return (String)DefaultAuthenticationHelper.getAttribute(request, ATTR_CACHED_USERNAME);
    }

    public boolean isAuthenticationFailed(@Nonnull HttpServletRequest request) {
        Object attribute = DefaultAuthenticationHelper.getAttribute(request, "SPRING_SECURITY_LAST_EXCEPTION");
        return attribute != null;
    }

    public void setAuthenticationException(@Nonnull HttpServletRequest request, AuthenticationException e) {
        DefaultAuthenticationHelper.setAttribute(request, "SPRING_SECURITY_LAST_EXCEPTION", e);
    }

    public void setCachedUsername(@Nonnull HttpServletRequest request, String username) {
        DefaultAuthenticationHelper.setAttribute(request, ATTR_CACHED_USERNAME, StringUtils.isBlank((CharSequence)username) ? null : username);
    }

    private static Object getAttribute(HttpServletRequest request, String name) {
        Object value;
        HttpSession session = request.getSession(false);
        Object object = value = session == null ? null : session.getAttribute(name);
        if (value == null) {
            value = request.getAttribute(name);
        }
        return value;
    }

    private static void setAttribute(HttpServletRequest request, String name, Object value) {
        HttpSession session = request.getSession(false);
        if (value == null) {
            if (session != null) {
                session.removeAttribute(name);
            }
            request.removeAttribute(name);
        } else {
            if (session != null) {
                session.setAttribute(name, value);
            }
            request.setAttribute(name, value);
        }
    }
}

