/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandlerModuleDescriptor;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.auth.SimpleAuthentication;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.PermissionVoter;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.CaptchaResponse;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.auth.DefaultHttpAuthenticationContext;
import com.atlassian.stash.internal.auth.InternalAuthenticationService;
import com.atlassian.stash.internal.permission.PermissionVoterFactory;
import com.atlassian.stash.internal.user.CaptchaTicket;
import com.atlassian.stash.internal.user.InternalCaptchaService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.internal.web.FakeHttpServletRequest;
import com.atlassian.stash.internal.web.FakeHttpServletResponse;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=AuthenticationService.class)
@Component(value="authenticationService")
@Transactional(propagation=Propagation.SUPPORTS, noRollbackFor={AuthenticationException.class, NoSuchUserException.class})
public class DefaultAuthenticationService
implements InternalAuthenticationService {
    private static final String CAPTCHA = "captcha";
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthenticationService.class);
    private final InternalCaptchaService captchaService;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private final PermissionVoterFactory voterFactory;

    @Autowired
    public DefaultAuthenticationService(InternalCaptchaService captchaService, I18nService i18nService, PluginAccessor pluginAccessor, PermissionVoterFactory voterFactory) {
        this.captchaService = captchaService;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
        this.voterFactory = voterFactory;
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public com.atlassian.bitbucket.auth.Authentication authenticate(@Nonnull String token) {
        DefaultHttpAuthenticationContext context = new DefaultHttpAuthenticationContext((HttpServletRequest)new FakeHttpServletRequest(), (HttpServletResponse)new FakeHttpServletResponse(), (req, res) -> {}, "token", null, (Object)token);
        return (com.atlassian.bitbucket.auth.Authentication)this.authenticateInternal((HttpAuthenticationContext)context, false).orElseThrow(this::badCredentials);
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public com.atlassian.bitbucket.auth.Authentication authenticate(@Nonnull String username, @Nonnull String password) {
        return this.authenticateInternal(username, password, false);
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public com.atlassian.bitbucket.auth.Authentication authenticate(@Nonnull String username, @Nonnull String password, boolean isFormBased) {
        return this.authenticateInternal(username, password, false, isFormBased ? "form" : "basic");
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public Optional<StashUserAuthenticationToken> authenticate(@Nonnull HttpAuthenticationContext context) {
        return this.authenticateInternal(context, true);
    }

    @Nonnull
    @Unsecured(value="This needs to be available to unauthenticated contexts")
    public com.atlassian.bitbucket.auth.Authentication authenticateWithCaptcha(@Nonnull String username, @Nonnull String password) {
        return this.authenticateInternal(username, password, true);
    }

    @Nonnull
    public com.atlassian.bitbucket.auth.Authentication clear() {
        com.atlassian.bitbucket.auth.Authentication previous = this.get();
        SecurityContextHolder.clearContext();
        return previous;
    }

    @Nonnull
    public com.atlassian.bitbucket.auth.Authentication get() {
        Authentication token = SecurityContextHolder.getContext().getAuthentication();
        if (token instanceof com.atlassian.bitbucket.auth.Authentication) {
            return (com.atlassian.bitbucket.auth.Authentication)token;
        }
        return com.atlassian.bitbucket.auth.Authentication.ANONYMOUS;
    }

    @Nonnull
    public com.atlassian.bitbucket.auth.Authentication set(@Nonnull com.atlassian.bitbucket.auth.Authentication authentication) {
        StashUserAuthenticationToken token;
        com.atlassian.bitbucket.auth.Authentication prevAuthentication = this.get();
        if (authentication instanceof StashUserAuthenticationToken) {
            token = (StashUserAuthenticationToken)authentication;
        } else {
            PermissionVoter voter = this.voterFactory.create(authentication);
            token = new StashUserAuthenticationToken.Builder().properties(authentication.getProperties()).user((ApplicationUser)authentication.getUser().orElse(null)).voter(voter).build();
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        return prevAuthentication;
    }

    private com.atlassian.bitbucket.auth.Authentication authenticateInternal(String username, String password, boolean allowCaptcha) {
        return this.authenticateInternal(username, password, allowCaptcha, "basic");
    }

    private com.atlassian.bitbucket.auth.Authentication authenticateInternal(String username, String password, boolean allowCaptcha, String authenticationMethod) {
        DefaultHttpAuthenticationContext context = new DefaultHttpAuthenticationContext((HttpServletRequest)new FakeHttpServletRequest(), (HttpServletResponse)new FakeHttpServletResponse(), (req, res) -> {}, authenticationMethod, username, (Object)password);
        return (com.atlassian.bitbucket.auth.Authentication)this.authenticateInternal((HttpAuthenticationContext)context, allowCaptcha).orElseThrow(this::badCredentials);
    }

    @Nonnull
    private Optional<StashUserAuthenticationToken> authenticateInternal(@Nonnull HttpAuthenticationContext context, boolean allowCaptcha) {
        boolean credentialsProvided = this.isCredentialsProvided(context);
        Supplier captchaTicket = Suppliers.memoize(() -> this.captchaService.checkCaptcha(context.getUsername(), this.extractCaptchaResponse(context)));
        for (HttpAuthenticationHandlerModuleDescriptor moduleDescriptor : this.getSortedAuthenticationModuleDescriptors()) {
            String authenticatorKey = moduleDescriptor.getCompleteKey();
            Timer ignored = TimerUtils.start((String)("attemptAuthentication - " + authenticatorKey));
            try {
                HttpAuthenticationHandler authenticator = this.instantiateModule(moduleDescriptor);
                if (authenticator == null) {
                    log.debug("{}: Skipping broken authenticator '{}'", (Object)context, (Object)authenticatorKey);
                    continue;
                }
                UncheckedOperation authenticateOperation = () -> authenticator.performAuthentication(context);
                try {
                    boolean withCaptcha = allowCaptcha && credentialsProvided && moduleDescriptor.isCaptchaSupported();
                    log.trace("{}: Applying authenticator '{}' (CAPTCHA {})", new Object[]{context, authenticatorKey, withCaptcha ? "supported" : "unsupported"});
                    AuthenticationResult result = withCaptcha ? this.captchaService.authenticateWithCaptcha((CaptchaTicket)captchaTicket.get(), authenticateOperation) : (AuthenticationResult)authenticateOperation.perform();
                    if (result != null) {
                        ApplicationUser user = result.getUser();
                        log.debug("{}: Authenticator '{}' authenticated {} ({})", new Object[]{context, authenticatorKey, user.getName(), user.getId()});
                        Optional<StashUserAuthenticationToken> optional = Optional.of(this.createAuthenticationToken(user, result.getProperties()));
                        return optional;
                    }
                    log.trace("{}: Authenticator '{}' opted out", (Object)context, (Object)authenticatorKey);
                }
                catch (AuthenticationException | NoSuchUserException e) {
                    log.debug("{}: Authenticator '{}' rejected the authentication attempt", (Object)context, (Object)authenticatorKey);
                    throw e;
                }
                catch (NoClassDefFoundError | RuntimeException e) {
                    log.warn("{}: Authenticator '{}' threw an exception", new Object[]{context, authenticatorKey, e});
                }
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        if (credentialsProvided && context.getUsername() != null) {
            throw this.badCredentials();
        }
        return Optional.empty();
    }

    private AuthenticationException badCredentials() {
        throw new IncorrectPasswordAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.auth.failed", new Object[0]));
    }

    private StashUserAuthenticationToken createAuthenticationToken(@Nonnull ApplicationUser user, @Nonnull Map<String, Serializable> properties) {
        PermissionVoter voter = this.voterFactory.create(new SimpleAuthentication.Builder(Objects.requireNonNull(user, "user")).properties(Objects.requireNonNull(properties, "properties")).build());
        return new StashUserAuthenticationToken.Builder().properties(properties).user(user).voter(voter).build();
    }

    private CaptchaResponse extractCaptchaResponse(HttpAuthenticationContext context) {
        HttpSession session = context.getRequest().getSession(false);
        String challengeId = session == null ? null : session.getId();
        String userResponse = StringUtils.trimToNull((String)context.getRequest().getParameter(CAPTCHA));
        return StringUtils.isNotEmpty((CharSequence)challengeId) && userResponse != null ? new CaptchaResponse(challengeId, userResponse) : null;
    }

    private Iterable<HttpAuthenticationHandlerModuleDescriptor> getSortedAuthenticationModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationHandlerModuleDescriptor.class).stream().sorted().collect(Collectors.toList());
    }

    private HttpAuthenticationHandler instantiateModule(HttpAuthenticationHandlerModuleDescriptor moduleDescriptor) {
        return (HttpAuthenticationHandler)ModuleDescriptorUtils.toModule().apply(moduleDescriptor);
    }

    private boolean isCredentialsProvided(HttpAuthenticationContext context) {
        Object credentials = context.getCredentials();
        return StringUtils.isNotBlank((CharSequence)context.getUsername()) && credentials instanceof String && StringUtils.isNotEmpty((CharSequence)((String)credentials));
    }
}

